/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.home;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.security.oauth2.client.OAuth2ClientProperties;
import org.springframework.core.env.Environment;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.service.plugin.PluginFinderService;
import org.squashtest.tm.service.system.SystemAdministrationService;
import org.squashtest.tm.web.backend.controller.home.LoginPageController;

@RestController
@RequestMapping(value={"backend/login-page"})
public class LoginPageController {
    private final SystemAdministrationService systemAdministrationService;
    private final PluginFinderService pluginFinderService;
    @Value(value="${info.app.version}")
    private String version;
    @Autowired
    private Environment environment;
    @Autowired(required=false)
    private OAuth2ClientProperties oAuth2ClientProperties;

    public LoginPageController(SystemAdministrationService systemAdministrationService, PluginFinderService pluginFinderService) {
        this.systemAdministrationService = systemAdministrationService;
        this.pluginFinderService = pluginFinderService;
    }

    @GetMapping
    public WelcomePageData loadLoginPage() {
        String loginMessage = this.systemAdministrationService.findLoginMessage();
        boolean isH2 = this.isH2();
        boolean isOpenIdConnectPluginInstalled = this.isOpenIdConnectPluginInstalled();
        Set oAuth2ProviderNames = this.getConfiguredOAuth2Providers();
        return new WelcomePageData(loginMessage, this.version, isH2, isOpenIdConnectPluginInstalled, oAuth2ProviderNames);
    }

    private boolean isH2() {
        List<String> activeProfiles = Arrays.asList(this.environment.getActiveProfiles());
        return activeProfiles.contains("h2");
    }

    private boolean isOpenIdConnectPluginInstalled() {
        return this.pluginFinderService.isOpenIdConnectPluginInstalled();
    }

    private Set<String> getConfiguredOAuth2Providers() {
        if (this.oAuth2ClientProperties != null && !this.oAuth2ClientProperties.getProvider().keySet().isEmpty()) {
            return this.formatOAuth2ProviderNames(this.oAuth2ClientProperties.getProvider().keySet());
        }
        return Collections.emptySet();
    }

    private Set<String> formatOAuth2ProviderNames(Set<String> oAuth2ProviderNames) {
        return oAuth2ProviderNames.stream().map(String::toLowerCase).sorted(String::compareToIgnoreCase).collect(Collectors.toCollection(LinkedHashSet::new));
    }
}

