/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.execution;

import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.domain.execution.SessionNoteKind;
import org.squashtest.tm.service.execution.ExecutionModificationService;
import org.squashtest.tm.service.internal.display.dto.execution.SessionNoteView;
import org.squashtest.tm.web.backend.controller.execution.SessionNoteController;

@RestController
@RequestMapping(value={"/backend/session-note"})
public class SessionNoteController {
    private final ExecutionModificationService executionModificationService;

    public SessionNoteController(ExecutionModificationService executionModificationService) {
        this.executionModificationService = executionModificationService;
    }

    @PostMapping(value={"/create"})
    SessionNoteView createNote(@RequestBody SessionNotePatch sessionNotePatch, @RequestParam(value="executionId") Long executionId) {
        SessionNoteKind noteKind = SessionNoteKind.valueOf((String)sessionNotePatch.getNoteKind());
        String noteContent = sessionNotePatch.getNoteContent();
        Integer noteOrder = sessionNotePatch.getNoteOrder();
        return this.executionModificationService.createSessionNote(executionId.longValue(), noteKind, noteContent, noteOrder);
    }

    @PostMapping(value={"{sessionNoteId}/kind"})
    @ResponseBody
    public SessionNoteView updateNoteKind(@RequestBody SessionNotePatch sessionNotePatch, @PathVariable long sessionNoteId) {
        SessionNoteKind newKind = SessionNoteKind.valueOf((String)sessionNotePatch.getNoteKind());
        return this.executionModificationService.updateSessionNoteKind(sessionNoteId, newKind);
    }

    @PostMapping(value={"{sessionNoteId}/content"})
    @ResponseBody
    public SessionNoteView updateNoteContent(@RequestBody SessionNotePatch sessionNotePatch, @PathVariable long sessionNoteId) {
        return this.executionModificationService.updateSessionNoteContent(sessionNoteId, sessionNotePatch.getNoteContent());
    }

    @DeleteMapping(value={"{sessionNoteId}"})
    @ResponseBody
    public void deleteNote(@PathVariable long sessionNoteId) {
        this.executionModificationService.deleteSessionNote(sessionNoteId);
    }
}

