/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.execution;

import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.security.UserContextHolder;
import org.squashtest.tm.service.execution.ExploratorySessionService;
import org.squashtest.tm.web.backend.controller.execution.ExploratorySessionController;

@RestController
@RequestMapping(value={"/backend/exploratory-session/{executionId}"})
public class ExploratorySessionController {
    private final ExploratorySessionService exploratorySessionService;

    public ExploratorySessionController(ExploratorySessionService exploratorySessionService) {
        this.exploratorySessionService = exploratorySessionService;
    }

    @PostMapping(value={"run"})
    public void runSession(@PathVariable(value="executionId") Long executionId) {
        this.exploratorySessionService.startOrResumeSession(executionId.longValue(), UserContextHolder.getUsername());
    }

    @PostMapping(value={"pause"})
    public void pauseSession(@PathVariable(value="executionId") Long executionId) {
        this.exploratorySessionService.pauseSession(executionId.longValue(), UserContextHolder.getUsername());
    }

    @PostMapping(value={"stop"})
    public void stopSession(@PathVariable(value="executionId") Long executionId) {
        this.exploratorySessionService.stopSession(executionId.longValue(), UserContextHolder.getUsername());
    }

    @PostMapping(value={"assign-user-to-exploratory-execution"})
    public void assignUser(@PathVariable(value="executionId") Long executionId, @RequestBody ExploratorySessionPatch exploratorySessionPatch) {
        this.exploratorySessionService.assignUser(executionId, exploratorySessionPatch.userId);
    }

    @PostMapping(value={"update-task-division"})
    public void updateTaskDivision(@PathVariable(value="executionId") Long executionId, @RequestBody ExploratorySessionPatch exploratorySessionPatch) {
        this.exploratorySessionService.updateTaskDivision(executionId, exploratorySessionPatch.taskDivision);
    }

    @PostMapping(value={"update-review-status"})
    public void updateReviewStatus(@PathVariable(value="executionId") Long executionId, @RequestBody ExploratorySessionPatch exploratorySessionPatch) {
        this.exploratorySessionService.updateReviewStatus(executionId, exploratorySessionPatch.reviewed);
    }
}

