/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.campaign;

import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.service.campaign.TestSuiteModificationService;
import org.squashtest.tm.web.backend.controller.campaign.TestSuiteModificationController;

@RestController
@RequestMapping(value={"backend/test-suite/{testSuiteId}"})
public class TestSuiteModificationController {
    private final TestSuiteModificationService testSuiteModificationService;

    public TestSuiteModificationController(TestSuiteModificationService testSuiteModificationService) {
        this.testSuiteModificationService = testSuiteModificationService;
    }

    @ResponseBody
    @PostMapping(value={"/name"})
    public void rename(@PathVariable Long testSuiteId, @RequestBody TestSuitePatch patch) {
        this.testSuiteModificationService.rename(testSuiteId.longValue(), patch.getName());
    }

    @ResponseBody
    @PostMapping(value={"/description"})
    public void changeDescription(@PathVariable Long testSuiteId, @RequestBody TestSuitePatch patch) {
        this.testSuiteModificationService.changeDescription(testSuiteId.longValue(), patch.getDescription());
    }

    @ResponseBody
    @PostMapping(value={"/execution-status"})
    public void changeExecutionStatus(@PathVariable Long testSuiteId, @RequestBody TestSuitePatch patch) {
        this.testSuiteModificationService.changeExecutionStatus(testSuiteId.longValue(), ExecutionStatus.valueOf((String)patch.getExecutionStatus()));
    }
}

