/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.bugtracker;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.csp.core.bugtracker.core.BugTrackerNoCredentialsDetailedException;
import org.squashtest.csp.core.bugtracker.core.BugTrackerNoCredentialsException;
import org.squashtest.csp.core.bugtracker.domain.BugTracker;
import org.squashtest.csp.core.bugtracker.net.AuthenticationException;
import org.squashtest.tm.core.foundation.exception.InvalidUrlException;
import org.squashtest.tm.core.foundation.lang.UrlUtils;
import org.squashtest.tm.domain.servers.AuthenticationPolicy;
import org.squashtest.tm.domain.servers.AuthenticationProtocol;
import org.squashtest.tm.exception.WrongUrlException;
import org.squashtest.tm.exception.bugtracker.BadCredentialsException;
import org.squashtest.tm.exception.bugtracker.CannotConnectBugtrackerException;
import org.squashtest.tm.service.bugtracker.BugTrackerManagerService;
import org.squashtest.tm.service.bugtracker.BugTrackerModificationService;
import org.squashtest.tm.service.internal.servers.OAuth2ConsumerService;
import org.squashtest.tm.service.servers.ManageableCredentials;
import org.squashtest.tm.service.servers.ServerAuthConfiguration;
import org.squashtest.tm.web.backend.controller.bugtracker.BugTrackerModificationController;
import org.squashtest.tm.web.backend.controller.form.model.BugtrackerFormModel;

@Controller
@RequestMapping(value={"/backend/bugtracker/"})
public class BugTrackerModificationController {
    private static final Logger LOGGER = LoggerFactory.getLogger(BugTrackerModificationController.class);
    private final BugTrackerManagerService bugTrackerManagerService;
    private final BugTrackerModificationService bugtrackerModificationService;
    private final OAuth2ConsumerService oAuth2ConsumerService;

    BugTrackerModificationController(BugTrackerManagerService bugTrackerManagerService, BugTrackerModificationService bugtrackerModificationService, OAuth2ConsumerService oAuth2ConsumerService) {
        this.bugTrackerManagerService = bugTrackerManagerService;
        this.bugtrackerModificationService = bugtrackerModificationService;
        this.oAuth2ConsumerService = oAuth2ConsumerService;
    }

    @ResponseBody
    @PostMapping(value={"/new"})
    public Map<String, Object> addBugTracker(@Valid @RequestBody BugtrackerFormModel bugTrackerFormModel) {
        try {
            BugTracker bugTracker = bugTrackerFormModel.getBugtracker();
            UrlUtils.toUrl((String)bugTrackerFormModel.getUrl());
            this.bugTrackerManagerService.addBugTracker(bugTracker);
            return Collections.singletonMap("id", bugTracker.getId());
        }
        catch (InvalidUrlException iue) {
            throw new WrongUrlException("url", (Throwable)iue);
        }
    }

    @ResponseBody
    @GetMapping(value={"/get-bugtracker-kinds"})
    public Map<String, Set<String>> getBugTrackerKinds() {
        return Collections.singletonMap("bugtrackerKinds", this.bugTrackerManagerService.findBugTrackerKinds());
    }

    @ResponseBody
    @DeleteMapping(value={"/{bugtrackerIds}"})
    public void deleteBugtrackers(@PathVariable List<Long> bugtrackerIds) {
        LOGGER.debug("ids of bugtracker to delete " + bugtrackerIds.toString());
        this.bugTrackerManagerService.deleteBugTrackers(bugtrackerIds);
    }

    @ResponseBody
    @PostMapping(value={"{bugtrackerId}/name"})
    public void changeName(@PathVariable long bugtrackerId, @RequestBody BugTrackerPatch patch) {
        this.bugtrackerModificationService.changeName(bugtrackerId, patch.getName());
    }

    @PostMapping(value={"{bugtrackerId}/url"})
    @ResponseBody
    public void changeUrl(@PathVariable long bugtrackerId, @RequestBody BugTrackerPatch patch) {
        this.checkUrl(patch.getUrl());
        this.bugtrackerModificationService.changeUrl(bugtrackerId, patch.getUrl());
    }

    @PostMapping(value={"{bugtrackerId}/kind"})
    @ResponseBody
    public void changeKind(@PathVariable long bugtrackerId, @RequestBody BugTrackerPatch patch) {
        this.bugtrackerModificationService.changeKind(bugtrackerId, patch.getKind());
    }

    @PostMapping(value={"{bugtrackerId}/iframe-friendly"})
    @ResponseBody
    public void changeIframeFriendly(@PathVariable long bugtrackerId, @RequestBody BugTrackerPatch patch) {
        this.bugtrackerModificationService.changeIframeFriendly(bugtrackerId, patch.isIframeFriendly());
    }

    @PostMapping(value={"{bugtrackerId}/auth-protocol"})
    @ResponseBody
    public void changeAuthProtocol(@PathVariable long bugtrackerId, @RequestBody BugTrackerPatch patch) {
        try {
            AuthenticationProtocol protocol = Enum.valueOf(AuthenticationProtocol.class, patch.getAuthProtocol());
            this.bugtrackerModificationService.changeAuthenticationProtocol(bugtrackerId, protocol);
        }
        catch (IllegalArgumentException e) {
            throw new AuthenticationException("Unknown authentication protocol " + patch.getAuthProtocol(), (Throwable)e);
        }
    }

    @PostMapping(value={"{bugTrackerId}/auth-protocol/configuration"})
    @ResponseBody
    public void saveAuthConfiguration(@PathVariable long bugTrackerId, @Valid @RequestBody ServerAuthConfiguration configuration) {
        this.bugtrackerModificationService.storeAuthConfiguration(bugTrackerId, configuration);
    }

    @PostMapping(value={"/{bugTrackerId}/auth-policy"})
    @ResponseBody
    public void changeAuthPolicy(@PathVariable long bugTrackerId, @RequestBody BugTrackerPatch patch) {
        try {
            AuthenticationPolicy policy = Enum.valueOf(AuthenticationPolicy.class, patch.getAuthPolicy());
            this.bugtrackerModificationService.changeAuthenticationPolicy(bugTrackerId, policy);
        }
        catch (IllegalArgumentException e) {
            throw new AuthenticationException("Unknown authentication policy " + patch.getAuthPolicy(), (Throwable)e);
        }
    }

    private void checkUrl(String url) {
        try {
            UrlUtils.toUrl((String)url);
        }
        catch (InvalidUrlException iue) {
            throw new WrongUrlException("url", (Throwable)iue);
        }
    }

    @PostMapping(value={"/{bugTrackerId}/credentials"})
    @ResponseBody
    public void storeCredentials(@PathVariable long bugTrackerId, @RequestBody ManageableCredentials credentials) {
        try {
            this.testCredentials(bugTrackerId, credentials);
            this.bugtrackerModificationService.storeCredentials(bugTrackerId, credentials);
        }
        catch (BugTrackerNoCredentialsDetailedException | BugTrackerNoCredentialsException e) {
            throw new BadCredentialsException((Exception)e);
        }
        catch (Exception e) {
            throw new CannotConnectBugtrackerException(e);
        }
    }

    private void testCredentials(long bugTrackerId, ManageableCredentials credentials) {
        this.bugtrackerModificationService.testCredentials(bugTrackerId, credentials);
    }

    @DeleteMapping(value={"/{bugTrackerId}/credentials"})
    @ResponseBody
    public void deleteBugtrackerCredentials(@PathVariable long bugTrackerId) {
        this.bugtrackerModificationService.deleteCredentials(bugTrackerId);
    }

    @PostMapping(value={"/{bugTrackerId}/authentication/oauth2/token"})
    @ResponseBody
    public void askOauth2Token(@PathVariable(value="bugTrackerId") long bugTrackerId, @RequestParam(value="code") String code) {
        this.oAuth2ConsumerService.getOauth2token(Long.valueOf(bugTrackerId), code, null);
    }
}

