/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.attachment;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Objects;
import javax.inject.Inject;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.domain.attachment.Attachment;
import org.squashtest.tm.exception.attachment.AttachmentException;
import org.squashtest.tm.service.attachment.AttachmentManagerService;
import org.squashtest.tm.service.display.attachment.FileViewerService;
import org.squashtest.tm.service.internal.display.attachment.FileViewerExtension;
import org.squashtest.tm.service.internal.display.dto.FileViewerDto;

@RestController
@RequestMapping(value={"backend/attachment/{attachmentId}"})
public class FileViewerController {
    @Inject
    private AttachmentManagerService attachmentManagerService;
    @Inject
    private FileViewerService fileViewerService;

    @GetMapping(value={"/{attachmentName}"})
    public void previewAttachment(@PathVariable(value="attachmentId") long attachmentId, @PathVariable(value="attachmentName") String attachmentName, HttpServletResponse response) {
        Attachment attachment = this.attachmentManagerService.findAttachment(Long.valueOf(attachmentId));
        String formattedName = String.valueOf(attachmentName.replace(" ", "_")) + "\"";
        try {
            FileViewerExtension fileType = Arrays.stream(FileViewerExtension.values()).filter(extension -> extension.name().equalsIgnoreCase(attachment.getType())).findAny().orElse(null);
            if (Objects.nonNull(fileType)) {
                this.displayAttachmentPreview(response, attachment, fileType, formattedName);
            } else {
                this.downloadAttachment(attachmentId, response, formattedName);
            }
        }
        catch (IOException e) {
            throw new AttachmentException((Throwable)e);
        }
    }

    private void displayAttachmentPreview(HttpServletResponse response, Attachment attachment, FileViewerExtension fileType, String formattedName) throws IOException {
        FileViewerDto fileViewer = this.fileViewerService.previewAttachment(attachment, fileType);
        response.setHeader("Content-Disposition", "inline; filename=" + formattedName);
        response.setContentType(fileViewer.getType().media);
        response.setCharacterEncoding(Charset.defaultCharset().name());
        if (fileViewer.getType().isOutputStream) {
            ServletOutputStream outputStream = response.getOutputStream();
            outputStream.write((byte[])fileViewer.getContent());
        } else {
            PrintWriter writer = response.getWriter();
            writer.print(fileViewer.getContent());
            writer.flush();
        }
    }

    private void downloadAttachment(long attachmentId, HttpServletResponse response, String formattedName) throws IOException {
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", "attachment; filename=\"" + formattedName);
        ServletOutputStream outStream = response.getOutputStream();
        this.attachmentManagerService.writeContent(attachmentId, (OutputStream)outStream);
    }
}

