/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.security.authentication;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationSuccessHandler;
import org.squashtest.tm.service.user.UserAdministrationService;

public class SinglePageAppAuthenticationSuccessHandler
extends SimpleUrlAuthenticationSuccessHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(SinglePageAppAuthenticationSuccessHandler.class);
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    UserAdministrationService userAdministrationService;

    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        LOGGER.debug("Authentication success for user {}", (Object)authentication);
        response.setStatus(200);
        response.setContentType("application/json");
        HashMap<String, Boolean> data = new HashMap<String, Boolean>();
        data.put("authenticated", true);
        data.put("showInformation", this.userAdministrationService.findPostLoginInformation().size() != 0);
        response.getOutputStream().print(this.objectMapper.writeValueAsString(data));
        this.clearAuthenticationAttributes(request);
    }
}

