/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.generic;

import java.util.EnumSet;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.error.ErrorAttributeOptions;
import org.springframework.boot.web.servlet.error.ErrorAttributes;
import org.springframework.boot.web.servlet.error.ErrorController;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.WebRequest;
import org.squashtest.tm.service.feature.FeatureManager;
import org.squashtest.tm.web.internal.controller.generic.SquashErrorController;

@Controller
public class SquashErrorController
implements ErrorController {
    @Value(value="${squashtm.stack.trace.control.panel.visible:true}")
    private Boolean stackTracePanel;
    @Inject
    private FeatureManager featureManager;
    private static final String PATH = "/error";
    @Inject
    private ErrorAttributes errorAttributes;

    public String error(HttpServletRequest request, HttpServletResponse response, Model model) throws Throwable {
        Map errors = this.getErrorAttributes(request, response);
        model.addAllAttributes(errors);
        model.addAttribute("code", (Object)response.getStatus());
        return "page/error";
    }

    @RequestMapping(value={"/error"})
    @ResponseBody
    public Map<String, Object> errorJson(HttpServletRequest request, HttpServletResponse response, Model model) throws Throwable {
        return this.getErrorAttributes(request, response);
    }

    public String getErrorPath() {
        return PATH;
    }

    private Map<String, Object> getErrorAttributes(HttpServletRequest request, HttpServletResponse response) {
        1 webRequest = new /* Unavailable Anonymous Inner Class!! */;
        Map<String, Object> result = this.errorAttributes.getErrorAttributes((WebRequest)webRequest, ErrorAttributeOptions.of(EnumSet.allOf(ErrorAttributeOptions.Include.class)));
        if (this.featureManager.isEnabled(FeatureManager.Feature.STACK_TRACE) && this.stackTracePanel.booleanValue()) {
            response.setHeader("Stack-Trace", "enable");
        } else {
            result = result.entrySet().stream().filter(map -> "status".equals(map.getKey()) || "error".equals(map.getKey())).collect(Collectors.toMap(p -> (String)p.getKey(), p -> p.getValue()));
        }
        return result;
    }
}

