/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.config;

import com.fasterxml.jackson.datatype.hibernate5.Hibernate5Module;
import java.util.HashMap;
import javax.inject.Inject;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import org.springframework.boot.autoconfigure.thymeleaf.ThymeleafProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Role;
import org.springframework.core.annotation.Order;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;
import org.squashtest.tm.api.config.SquashPathProperties;
import org.squashtest.tm.service.servers.CredentialsProvider;
import org.squashtest.tm.web.backend.context.ReloadableSquashTmMessageSource;
import org.squashtest.tm.web.backend.fileupload.MultipartResolverDispatcher;
import org.squashtest.tm.web.backend.fileupload.SquashMultipartResolver;
import org.squashtest.tm.web.backend.filter.AjaxEmptyResponseFilter;
import org.squashtest.tm.web.backend.filter.MultipartFilterExceptionAware;
import org.squashtest.tm.web.backend.filter.UserConcurrentRequestLockFilter;
import org.squashtest.tm.web.backend.filter.UserCredentialsCachePersistenceFilter;
import org.squashtest.tm.web.backend.filter.xss.XssFilter;
import org.squashtest.tm.web.backend.listener.HttpSessionLifecycleLogger;
import org.squashtest.tm.web.config.MessagesProperties;
import org.thymeleaf.spring5.templateresolver.SpringResourceTemplateResolver;
import org.thymeleaf.templateresolver.ITemplateResolver;

@EnableConfigurationProperties(value={MessagesProperties.class})
@Configuration
public class SquashServletConfig {
    private static final String[] CREDENTIALS_CACHE_EXCLUDE_PATTERNS = new String[]{"/isSquashAlive/**", "/scripts/**", "/static/**", "/images/**", "/styles/**"};
    private static final String IMPORTER_REGEX = ".*/importer/.*";
    private static final String UPLOAD_REGEX = ".*/attachments/upload.*";
    @Inject
    private MessagesProperties messagesProperties;
    @Inject
    private ThymeleafProperties thymeleafProperties;
    @Inject
    private SquashPathProperties squashPathProperties;
    @Inject
    private CredentialsProvider credentialsProvider;

    @Bean
    public MessageSource messageSource() {
        ReloadableSquashTmMessageSource bean = new ReloadableSquashTmMessageSource();
        bean.setSquashPathProperties(this.squashPathProperties);
        bean.setBasenames(StringUtils.commaDelimitedListToStringArray((String)StringUtils.trimAllWhitespace((String)this.messagesProperties.getBasename())));
        bean.setDefaultEncoding(this.messagesProperties.getEncoding());
        bean.setCacheSeconds(this.messagesProperties.getCacheSeconds());
        return bean;
    }

    @Bean(name={"thymeleaf.templateResolver.angular"})
    public ITemplateResolver thymeleafAngularTemplateResolver(ApplicationContext context) {
        SpringResourceTemplateResolver res = new SpringResourceTemplateResolver();
        res.setApplicationContext(context);
        res.setPrefix("classpath:/META-INF/resources/");
        res.setSuffix("");
        res.setTemplateMode(this.thymeleafProperties.getMode());
        res.setCharacterEncoding(this.thymeleafProperties.getEncoding().name());
        res.setCacheable(this.thymeleafProperties.isCache());
        res.setOrder(Integer.valueOf(1));
        return res;
    }

    @Bean
    @Role(value=1)
    public CommonsMultipartResolver filterMultipartResolver() {
        MultipartResolverDispatcher bean = new MultipartResolverDispatcher();
        bean.setDefaultResolver(this.defaultMultipartResolver());
        HashMap<String, SquashMultipartResolver> resolverMap = new HashMap<String, SquashMultipartResolver>();
        resolverMap.put(UPLOAD_REGEX, this.importMultipartResolver("uploadfilter.upload.sizeLimitInBytes"));
        resolverMap.put(IMPORTER_REGEX, this.importMultipartResolver("uploadfilter.upload.import.sizeLimitInBytes"));
        bean.setResolverMap(resolverMap);
        return bean;
    }

    @Role(value=1)
    public SquashMultipartResolver defaultMultipartResolver() {
        SquashMultipartResolver bean = new SquashMultipartResolver();
        return bean;
    }

    @Role(value=1)
    public SquashMultipartResolver importMultipartResolver(String configKey) {
        SquashMultipartResolver bean = new SquashMultipartResolver();
        bean.setMaxUploadSizeKey(configKey);
        return bean;
    }

    @Bean
    public FilterRegistrationBean multipartFilterRegistrationBean() {
        MultipartFilterExceptionAware multipartFilter = new MultipartFilterExceptionAware();
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean((Filter)multipartFilter, new ServletRegistrationBean[0]);
        return filterRegistrationBean;
    }

    @Bean
    @Order(value=1)
    public FilterRegistrationBean bugTrackerContextPersister() {
        UserCredentialsCachePersistenceFilter filter = new UserCredentialsCachePersistenceFilter();
        filter.setCredentialsProvider(this.credentialsProvider);
        filter.addExcludePatterns(CREDENTIALS_CACHE_EXCLUDE_PATTERNS);
        FilterRegistrationBean bean = new FilterRegistrationBean((Filter)filter, new ServletRegistrationBean[0]);
        bean.setDispatcherTypes(DispatcherType.REQUEST, new DispatcherType[0]);
        return bean;
    }

    @Bean
    @Order(value=1000)
    public FilterRegistrationBean ajaxEmptyResponseFilter() {
        FilterRegistrationBean bean = new FilterRegistrationBean((Filter)new AjaxEmptyResponseFilter(), new ServletRegistrationBean[0]);
        bean.setDispatcherTypes(DispatcherType.REQUEST, new DispatcherType[0]);
        return bean;
    }

    @Bean
    @Order(value=500)
    public FilterRegistrationBean userConcurrentRequestLockFilter() {
        FilterRegistrationBean bean = new FilterRegistrationBean((Filter)new UserConcurrentRequestLockFilter(), new ServletRegistrationBean[0]);
        bean.addInitParameter("excludePatterns", "(/|/isSquashAlive|/opened-entity)");
        bean.setDispatcherTypes(DispatcherType.REQUEST, new DispatcherType[0]);
        return bean;
    }

    @Bean
    @Order(value=-2147483648)
    public FilterRegistrationBean<XssFilter> xssFilter() {
        FilterRegistrationBean bean = new FilterRegistrationBean((Filter)new XssFilter(), new ServletRegistrationBean[0]);
        bean.setDispatcherTypes(DispatcherType.REQUEST, new DispatcherType[0]);
        return bean;
    }

    @Bean
    public HttpSessionLifecycleLogger httpSessionLifecycleLogger() {
        return new HttpSessionLifecycleLogger();
    }

    @Bean
    public Hibernate5Module hibernate5JacksonModule() {
        Hibernate5Module bean = new Hibernate5Module();
        bean.configure(Hibernate5Module.Feature.FORCE_LAZY_LOADING, true);
        return bean;
    }
}

