/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.exceptionresolver;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.handler.AbstractHandlerExceptionResolver;
import org.springframework.web.servlet.view.json.MappingJackson2JsonView;
import org.squashtest.tm.core.scm.api.exception.ScmException;
import org.squashtest.tm.web.backend.exceptionresolver.model.ActionValidationErrorModel;
import org.squashtest.tm.web.backend.exceptionresolver.model.FieldValidationErrorModel;
import org.squashtest.tm.web.backend.exceptionresolver.model.SquashActionErrorModel;
import org.squashtest.tm.web.backend.exceptionresolver.model.SquashFieldValidationErrorModel;

@Component
public class HandlerScmExceptionResolver
extends AbstractHandlerExceptionResolver {
    protected ModelAndView doResolveException(HttpServletRequest request, HttpServletResponse response, @Nullable Object handler, Exception ex) {
        if (this.exceptionIsHandled(ex)) {
            response.setStatus(412);
            ScmException scmException = (ScmException)ex;
            if (scmException.hasField()) {
                List errors = this.buildFieldValidationErrors(scmException);
                SquashFieldValidationErrorModel squashError = new SquashFieldValidationErrorModel(errors);
                return new ModelAndView((View)new MappingJackson2JsonView(), "squashTMError", (Object)squashError);
            }
            ActionValidationErrorModel model = new ActionValidationErrorModel(scmException.getClass().getSimpleName(), scmException.getMessage(), null);
            SquashActionErrorModel squashActionErrorModel = new SquashActionErrorModel(model);
            return new ModelAndView((View)new MappingJackson2JsonView(), "squashTMError", (Object)squashActionErrorModel);
        }
        return null;
    }

    private List<FieldValidationErrorModel> buildFieldValidationErrors(ScmException scmException) {
        ArrayList<FieldValidationErrorModel> ves = new ArrayList<FieldValidationErrorModel>();
        ves.add(new FieldValidationErrorModel("", scmException.getField(), scmException.getMessage()));
        return ves;
    }

    private boolean exceptionIsHandled(Exception ex) {
        return ex instanceof ScmException;
    }
}

