/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.tf;

import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.domain.testautomation.AutomatedSuite;
import org.squashtest.tm.service.testautomation.AutomatedSuiteManagerService;
import org.squashtest.tm.service.testautomation.model.AutomatedSuiteCreationSpecification;
import org.squashtest.tm.service.testautomation.model.AutomatedSuitePreview;
import org.squashtest.tm.service.testautomation.model.AutomatedSuiteWithSquashAutomAutomatedITPIs;
import org.squashtest.tm.web.backend.controller.tf.AutomatedExecutionViewUtils;

@Controller
@RequestMapping(value={"backend/automated-suites"})
public class AutomatedSuiteManagementController {
    private static final Logger LOGGER = LoggerFactory.getLogger(AutomatedSuiteManagementController.class);
    @Inject
    private AutomatedSuiteManagerService automatedSuiteService;

    @RequestMapping(value={"/preview"}, method={RequestMethod.POST})
    @ResponseBody
    public AutomatedSuitePreview generateSuitePreview(@RequestBody AutomatedSuiteCreationSpecification specification) {
        return this.automatedSuiteService.preview(specification);
    }

    @ResponseBody
    @RequestMapping(value={"/preview/test-list"}, method={RequestMethod.POST}, params={"auto-project-id"})
    public List<String> findTestListPreview(@RequestBody AutomatedSuiteCreationSpecification specification, @RequestParam(value="auto-project-id") Long automatedProjectId) {
        return this.automatedSuiteService.findTestListPreview(specification, automatedProjectId.longValue());
    }

    @ResponseBody
    @RequestMapping(value={"/create-and-execute"}, method={RequestMethod.POST})
    public AutomatedExecutionViewUtils.AutomatedSuiteOverview createAndExecute(@RequestBody AutomatedSuiteCreationSpecification specification) {
        AutomatedSuiteWithSquashAutomAutomatedITPIs suite = this.automatedSuiteService.createAndExecute(specification);
        Date startDate = new Date();
        LOGGER.debug("START CREATING AUTOMATED SUITE OVERVIEW " + startDate);
        AutomatedExecutionViewUtils.AutomatedSuiteOverview automatedSuiteOverview = AutomatedExecutionViewUtils.buildExecInfo((AutomatedSuiteWithSquashAutomAutomatedITPIs)suite);
        Date endDate = new Date();
        LOGGER.debug("END CREATING AUTOMATED SUITE OVERVIEW " + endDate);
        return automatedSuiteOverview;
    }

    @ResponseBody
    @RequestMapping(value={"/{suiteId}/executions"}, method={RequestMethod.GET})
    public AutomatedExecutionViewUtils.AutomatedSuiteOverview updateExecutionInfo(@PathVariable String suiteId) {
        AutomatedSuite suite = this.automatedSuiteService.findById(suiteId);
        return AutomatedExecutionViewUtils.buildExecInfo((AutomatedSuite)suite);
    }
}

