/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.testcase.parameters;

import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.domain.testcase.Parameter;
import org.squashtest.tm.exception.DuplicateNameException;
import org.squashtest.tm.exception.NameAlreadyInUseException;
import org.squashtest.tm.service.display.testcase.TestCaseDisplayService;
import org.squashtest.tm.service.internal.display.testcase.parameter.TestCaseParameterRenameOperationReport;
import org.squashtest.tm.service.testcase.ParameterFinder;
import org.squashtest.tm.service.testcase.ParameterModificationService;
import org.squashtest.tm.web.backend.controller.testcase.parameters.ParameterPatch;

@Controller
@RequestMapping(value={"backend/parameters"})
public class ParameterController {
    private static final String PARAMETER_ID_URL = "/{parameterId}";
    private static final String PARAMETER_USED = "PARAMETER_USED";
    private ParameterModificationService parameterService;
    private TestCaseDisplayService testCaseDisplayService;
    private ParameterFinder parameterFinder;

    public ParameterController(ParameterModificationService parameterService, TestCaseDisplayService testCaseDisplayService, ParameterFinder parameterFinder) {
        this.parameterService = parameterService;
        this.testCaseDisplayService = testCaseDisplayService;
        this.parameterFinder = parameterFinder;
    }

    @RequestMapping(value={"/{parameterId}/used"}, method={RequestMethod.GET})
    @ResponseBody
    public Map<String, Boolean> isUsedParameter(@PathVariable Long parameterId) {
        HashMap<String, Boolean> used = new HashMap<String, Boolean>();
        used.put(PARAMETER_USED, this.parameterService.isUsed(parameterId.longValue()));
        return used;
    }

    @RequestMapping(value={"/{parameterId}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public void removeParameter(@PathVariable Long parameterId) {
        this.parameterService.removeById(parameterId.longValue());
    }

    @RequestMapping(value={"/{parameterId}/rename"}, method={RequestMethod.POST})
    @ResponseBody
    public TestCaseParameterRenameOperationReport renameParameter(@PathVariable Long parameterId, @RequestBody ParameterPatch patch) {
        try {
            this.parameterService.changeName(parameterId.longValue(), patch.getName());
            Parameter parameter = this.parameterFinder.findById(parameterId.longValue());
            return new TestCaseParameterRenameOperationReport(this.testCaseDisplayService.findTestStepsByTestCaseId(parameter.getTestCase().getId()), parameter.getTestCase().getPrerequisite());
        }
        catch (DuplicateNameException duplicateNameException) {
            throw new NameAlreadyInUseException("Parameter", patch.getName());
        }
    }

    @RequestMapping(value={"/{parameterId}/description"}, method={RequestMethod.POST})
    @ResponseBody
    public void changeDescription(@PathVariable Long parameterId, @RequestBody ParameterPatch patch) {
        this.parameterService.changeDescription(parameterId.longValue(), patch.getDescription());
    }
}

