/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.test.automation.server;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.service.display.environmentvariable.EnvironmentVariableDisplayService;
import org.squashtest.tm.service.display.test.automation.server.TestAutomationServerDisplayService;
import org.squashtest.tm.service.internal.display.dto.EnvironmentVariableDto;
import org.squashtest.tm.service.internal.display.dto.TestAutomationServerAdminViewDto;

@RestController
@RequestMapping(value={"/backend/test-automation-server-view"})
public class TestAutomationServerViewController {
    private final TestAutomationServerDisplayService testAutomationServerDisplayService;
    private final EnvironmentVariableDisplayService environmentVariableDisplayService;

    @Inject
    TestAutomationServerViewController(TestAutomationServerDisplayService testAutomationServerDisplayService, EnvironmentVariableDisplayService environmentVariableDisplayService) {
        this.testAutomationServerDisplayService = testAutomationServerDisplayService;
        this.environmentVariableDisplayService = environmentVariableDisplayService;
    }

    @RequestMapping(value={"/{testAutomationServerId}"}, method={RequestMethod.GET})
    @ResponseBody
    public TestAutomationServerAdminViewDto getView(@PathVariable long testAutomationServerId) {
        return this.testAutomationServerDisplayService.getTestAutomationServerView(testAutomationServerId);
    }

    @GetMapping(value={"/environment-variables"})
    @ResponseBody
    public Map<String, List<EnvironmentVariableDto>> getAllEnvironmentVariableReferences() {
        HashMap<String, List<EnvironmentVariableDto>> result = new HashMap<String, List<EnvironmentVariableDto>>();
        List variables = this.environmentVariableDisplayService.getAllEnvironmentVariableReferences();
        result.put("environmentVariables", variables);
        return result;
    }
}

