/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.search;

import java.util.List;
import java.util.stream.Collectors;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.query.Operation;
import org.squashtest.tm.service.campaign.IterationTestPlanManagerService;
import org.squashtest.tm.service.display.search.CampaignSearchGridDisplayService;
import org.squashtest.tm.service.display.search.CampaignSearchInputData;
import org.squashtest.tm.service.display.search.CampaignSearchInputDataProvider;
import org.squashtest.tm.service.display.search.CampaignSearchService;
import org.squashtest.tm.service.display.search.ResearchResult;
import org.squashtest.tm.service.internal.display.grid.GridFilterValue;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.grid.GridResponse;

@RestController
@RequestMapping(value={"backend/search/campaign"})
public class CampaignSearchController {
    private final CampaignSearchInputDataProvider inputDataProvider;
    private final CampaignSearchService campaignSearchService;
    private final CampaignSearchGridDisplayService campaignSearchGridDisplayService;
    private final IterationTestPlanManagerService iterationTestPlanManagerService;

    public CampaignSearchController(CampaignSearchInputDataProvider inputDataProvider, CampaignSearchService campaignSearchService, CampaignSearchGridDisplayService campaignSearchGridDisplayService, IterationTestPlanManagerService iterationTestPlanManagerService) {
        this.inputDataProvider = inputDataProvider;
        this.campaignSearchService = campaignSearchService;
        this.campaignSearchGridDisplayService = campaignSearchGridDisplayService;
        this.iterationTestPlanManagerService = iterationTestPlanManagerService;
    }

    @GetMapping
    public CampaignSearchInputData getSearchInputData() {
        return this.inputDataProvider.provide();
    }

    @PostMapping
    public GridResponse search(@RequestBody GridRequest gridRequest) {
        List testSuites = gridRequest.getScope().stream().filter(scope -> scope.contains("TestSuite")).collect(Collectors.toList());
        if (!testSuites.isEmpty()) {
            this.createFilterValueOnTestSuiteIds(gridRequest, testSuites);
        }
        ResearchResult result = this.campaignSearchService.search(gridRequest);
        return this.campaignSearchGridDisplayService.fetchResearchRows(result);
    }

    private void createFilterValueOnTestSuiteIds(GridRequest gridRequest, List<String> testSuites) {
        List testSuitesIds = testSuites.stream().map(EntityReference::fromNodeId).map(EntityReference::getId).map(String::valueOf).collect(Collectors.toList());
        GridFilterValue gridFilterValue = new GridFilterValue();
        gridFilterValue.setOperation(Operation.IN.name());
        gridFilterValue.setColumnPrototype("ITEM_SUITE_ID");
        gridFilterValue.setValues(testSuitesIds);
        gridRequest.getFilterValues().add(gridFilterValue);
        List scopeWithoutTestSuites = gridRequest.getScope().stream().filter(scope -> !scope.contains(EntityType.TEST_SUITE.getSimpleClassName())).collect(Collectors.toList());
        gridRequest.setScope(scopeWithoutTestSuites);
    }
}

