/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.project;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.domain.testautomation.TestAutomationProject;
import org.squashtest.tm.domain.users.Party;
import org.squashtest.tm.domain.users.User;
import org.squashtest.tm.service.display.project.ProjectDisplayService;
import org.squashtest.tm.service.internal.display.dto.BindMilestoneToProjectDialogData;
import org.squashtest.tm.service.internal.display.dto.ProjectViewDto;
import org.squashtest.tm.service.internal.display.dto.TestAutomationProjectDto;
import org.squashtest.tm.service.internal.utils.HTMLCleanupUtils;
import org.squashtest.tm.service.project.GenericProjectManagerService;
import org.squashtest.tm.web.backend.controller.project.ProjectViewController;
import org.squashtest.tm.web.backend.manager.plugin.ConfigurablePluginManager;

@RestController
@RequestMapping(value={"/backend/project-view"})
public class ProjectViewController {
    private final ProjectDisplayService projectViewDisplayService;
    private final GenericProjectManagerService projectManager;
    private final ConfigurablePluginManager pluginManager;

    @Inject
    ProjectViewController(ProjectDisplayService projectViewDisplayService, GenericProjectManagerService projectManager, ConfigurablePluginManager pluginManager) {
        this.projectViewDisplayService = projectViewDisplayService;
        this.projectManager = projectManager;
        this.pluginManager = pluginManager;
    }

    @GetMapping(value={"/{projectId}"})
    public ProjectViewDto getProjectView(@PathVariable long projectId) {
        ProjectViewDto dto = this.projectViewDisplayService.getProjectView(projectId);
        dto.setAvailablePlugins(this.pluginManager.getAvailablePlugins(projectId));
        return dto;
    }

    @GetMapping(value={"/{projectId}/statuses-in-use"})
    public Map<String, Boolean> getProjectStatusesInUse(@PathVariable long projectId) {
        return this.projectViewDisplayService.getProjectStatusesInUse(projectId);
    }

    @GetMapping(value={"/{projectId}/available-milestones"})
    public BindMilestoneToProjectDialogData getAvailableMilestones(@PathVariable long projectId) {
        return this.projectViewDisplayService.findAvailableMilestones(projectId);
    }

    @GetMapping(value={"/{projectId}/unbound-parties"})
    public UnboundPartiesResponse getUnboundParties(@PathVariable long projectId) {
        List partyList = this.projectManager.findPartyWithoutPermissionByProject(projectId);
        ArrayList<UnboundParty> users = new ArrayList<UnboundParty>();
        ArrayList<UnboundParty> teams = new ArrayList<UnboundParty>();
        for (Party p : partyList) {
            boolean isUser = User.class.isAssignableFrom(p.getClass());
            Long id = p.getId();
            String label = HTMLCleanupUtils.cleanAndUnescapeHTML((String)p.getName());
            UnboundParty unboundParty = new UnboundParty(id, label);
            if (isUser) {
                users.add(unboundParty);
                continue;
            }
            teams.add(unboundParty);
        }
        return new UnboundPartiesResponse(users, teams);
    }

    @GetMapping(value={"/{projectId}/available-ta-projects"})
    @ResponseBody
    public Map<String, List<TestAutomationProjectDto>> getAvailableTAProjects(@PathVariable long projectId) {
        List dtos = this.projectManager.findAllAvailableTaProjects(projectId).stream().map(taProject -> TestAutomationProjectDto.fromRemoteTestAutomationProject((TestAutomationProject)taProject, (Long)projectId)).collect(Collectors.toList());
        return Collections.singletonMap("taProjects", dtos);
    }

    @GetMapping(value={"/{projectId}/restricted-ta-projects"})
    @ResponseBody
    public Map<String, List<TestAutomationProjectDto>> getAvailableTAProjectsForCurrentUser(@PathVariable long projectId) {
        List dtos = this.projectManager.findAllAvailableTaProjectsWithUserLevelCredentials(projectId).stream().map(taProject -> TestAutomationProjectDto.fromRemoteTestAutomationProject((TestAutomationProject)taProject, (Long)projectId)).collect(Collectors.toList());
        return Collections.singletonMap("taProjects", dtos);
    }
}

