/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.export.grid;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.squashtest.tm.service.internal.display.grid.DataRow;
import org.squashtest.tm.web.backend.controller.export.grid.GridExportModel;

public abstract class GridExporter {
    protected final GridExportModel gridExportModel;
    protected final SXSSFWorkbook workbook;
    protected final Sheet sheet;
    protected final List<Row> rows = new ArrayList();
    protected Row row;

    protected GridExporter(GridExportModel gridExportModel) {
        this.gridExportModel = gridExportModel;
        this.workbook = new SXSSFWorkbook(100);
        this.sheet = this.workbook.createSheet();
    }

    protected void printRows() {
        int i = 0;
        while (i < this.gridExportModel.getExportedRows().size()) {
            DataRow dataRow = (DataRow)this.gridExportModel.getExportedRows().get(i);
            this.printRow(i, dataRow);
            ++i;
        }
    }

    protected void printRow(int rowIndex, DataRow dataRow) {
        this.row = this.sheet.createRow(rowIndex + 1);
        int i = 0;
        while (i < this.gridExportModel.getExportedColumns().size()) {
            GridExportModel.ExportColumnDefinition exportColumnDefinition = (GridExportModel.ExportColumnDefinition)this.gridExportModel.getExportedColumns().get(i);
            Cell cell = this.row.createCell(i);
            Map data = dataRow.getData();
            String value = Optional.ofNullable(data.get(exportColumnDefinition.getId())).orElse("");
            cell.setCellValue(value.toString());
            ++i;
        }
        this.rows.add(this.row);
    }

    protected void printHeaders() {
        this.row = this.sheet.createRow(0);
        int i = 0;
        while (i < this.gridExportModel.getExportedColumns().size()) {
            GridExportModel.ExportColumnDefinition exportColumnDefinition = (GridExportModel.ExportColumnDefinition)this.gridExportModel.getExportedColumns().get(i);
            Cell cell = this.row.createCell(i);
            cell.setCellValue(exportColumnDefinition.getLabel());
            ++i;
        }
        this.rows.add(this.row);
    }

    abstract File export() throws IOException;
}

