/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.environmentVariable;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.squashtest.tm.domain.environmentvariable.EnvironmentVariable;
import org.squashtest.tm.domain.environmentvariable.EnvironmentVariableOption;
import org.squashtest.tm.exception.DomainException;
import org.squashtest.tm.service.display.environmentvariable.EnvironmentVariableDisplayService;
import org.squashtest.tm.service.environmentvariable.EnvironmentVariableManagerService;
import org.squashtest.tm.service.internal.display.dto.EnvironmentVariableDto;
import org.squashtest.tm.service.internal.display.dto.EnvironmentVariableOptionDto;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.grid.GridResponse;
import org.squashtest.tm.web.backend.controller.environmentVariable.EnvironmentVariableController;
import org.squashtest.tm.web.backend.controller.form.model.EnvironmentVariableFormModel;

@Controller
@RequestMapping(value={"/backend/environment-variables"})
public class EnvironmentVariableController {
    private final EnvironmentVariableManagerService environmentVariableManagerService;
    private final EnvironmentVariableDisplayService environmentVariableDisplayService;

    public EnvironmentVariableController(EnvironmentVariableManagerService environmentVariableManagerService, EnvironmentVariableDisplayService environmentVariableDisplayService) {
        this.environmentVariableManagerService = environmentVariableManagerService;
        this.environmentVariableDisplayService = environmentVariableDisplayService;
    }

    @ResponseBody
    @PostMapping
    public GridResponse getAllEnvironmentVariables(@RequestBody GridRequest request) {
        return this.environmentVariableDisplayService.findAll(request);
    }

    @ResponseStatus(value=HttpStatus.CREATED)
    @PostMapping(value={"/new"})
    @ResponseBody
    public Map<String, Object> createEnvironmentVariable(@RequestBody EnvironmentVariableFormModel model) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        EnvironmentVariable environmentVariable = model.getEnvironmentVariable();
        this.environmentVariableManagerService.persist(environmentVariable);
        response.put("id", environmentVariable.getId());
        return response;
    }

    @ResponseBody
    @DeleteMapping(value={"/{environmentVariableIds}"})
    public void deleteEnvironmentVariable(@PathVariable(value="environmentVariableIds") List<Long> environmentVariableIds) {
        this.environmentVariableManagerService.deleteEnvironmentVariable(environmentVariableIds);
    }

    @ResponseBody
    @PostMapping(value={"/{evId}/name"})
    public void changeName(@PathVariable long evId, @RequestBody EnvironmentVariablePatch patch) {
        this.environmentVariableManagerService.changeName(Long.valueOf(evId), patch.getName());
    }

    @ResponseBody
    @PostMapping(value={"/{evId}/code"})
    public void changeCode(@PathVariable long evId, @RequestBody EnvironmentVariablePatch patch) {
        this.environmentVariableManagerService.changeCode(Long.valueOf(evId), patch.getCode());
    }

    @ResponseBody
    @PostMapping(value={"/{evId}/options/code"})
    public void changeOptionCode(@PathVariable long evId, @RequestBody EnvironmentVariableOptionPatch patch) {
        this.environmentVariableManagerService.changeOptionCode(evId, patch.getCurrentLabel(), patch.getCode());
    }

    @ResponseBody
    @PostMapping(value={"/{evId}/options/label"})
    public void changeOptionLabel(@PathVariable long evId, @RequestBody EnvironmentVariableOptionPatch patch) {
        this.environmentVariableManagerService.changeOptionLabel(evId, patch.getCurrentLabel(), patch.getNewLabel());
    }

    @ResponseBody
    @PostMapping(value={"/{evId}/options/new"})
    public Map<String, List<EnvironmentVariableOptionDto>> addNewOption(@PathVariable long evId, @Valid @RequestBody EnvironmentVariableOption option) {
        HashMap<String, List<EnvironmentVariableOptionDto>> response = new HashMap<String, List<EnvironmentVariableOptionDto>>();
        try {
            this.environmentVariableManagerService.addOption(evId, option);
        }
        catch (DomainException e) {
            e.setObjectName("new-environment-variable-option");
            throw e;
        }
        response.put("options", this.environmentVariableDisplayService.getOptionsByEvId(Long.valueOf(evId)));
        return response;
    }

    @ResponseBody
    @PostMapping(value={"/{evId}/options/remove"})
    public void removeOptions(@PathVariable Long evId, @RequestBody Map<String, List<String>> request) {
        this.environmentVariableManagerService.removeOptions(evId, request.get("optionLabels"));
    }

    @ResponseBody
    @PostMapping(value={"/{environmentVariableId}/options/positions"})
    public EnvironmentVariableDto changeOptionsPositions(@PathVariable Long environmentVariableId, @RequestBody ReorderOptionsPatch patch) {
        this.environmentVariableManagerService.changeOptionsPosition(environmentVariableId, patch.getPosition(), patch.getLabels());
        return this.environmentVariableDisplayService.getEnvironmentVariableView(environmentVariableId);
    }
}

