/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.environmentVariable;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.service.environmentvariable.EnvironmentVariableBindingService;
import org.squashtest.tm.service.environmentvariable.EnvironmentVariableValueService;
import org.squashtest.tm.service.internal.display.dto.BoundEnvironmentVariableDto;
import org.squashtest.tm.web.backend.controller.environmentVariable.BoundEnvironmentVariableController;

@Controller
@RequestMapping(value={"/backend/bound-environment-variables"})
public class BoundEnvironmentVariableController {
    private final EnvironmentVariableBindingService environmentVariableBindingService;
    private final EnvironmentVariableValueService environmentVariableValueService;

    public BoundEnvironmentVariableController(EnvironmentVariableBindingService environmentVariableBindingService, EnvironmentVariableValueService environmentVariableValueService) {
        this.environmentVariableBindingService = environmentVariableBindingService;
        this.environmentVariableValueService = environmentVariableValueService;
    }

    @ResponseBody
    @GetMapping(value={"test-automation-server/{serverId}"})
    public Map<String, List<BoundEnvironmentVariableDto>> getBoundEnvironmentVariableFromServer(@PathVariable Long serverId) {
        return Collections.singletonMap("boundEnvironmentVariables", this.environmentVariableBindingService.getAllDefaultBoundEnvironmentVariableDto(serverId));
    }

    @ResponseBody
    @GetMapping(value={"project/{projectId}"})
    public Map<String, List<BoundEnvironmentVariableDto>> getBoundEnvironmentVariablesFromProject(@PathVariable Long projectId) {
        return Collections.singletonMap("boundEnvironmentVariables", this.environmentVariableBindingService.getAllBoundEnvironmentVariableDtoByProjectId(projectId));
    }

    @ResponseBody
    @PostMapping(value={"project/{projectId}/environment-variable/{environmentVariableId}/value"})
    public void editEnvironmentVariableValueFromProject(@PathVariable Long projectId, @PathVariable Long environmentVariableId, @RequestBody EnvironmentVariableProjectValuePatch patch) {
        this.environmentVariableValueService.editEnvironmentVariableValueFromProject(projectId, environmentVariableId, patch.getValue());
    }

    @ResponseBody
    @PostMapping(value={"project/{projectId}/environment-variable/{environmentVariableId}/reset"})
    public Map<String, String> resetEnvironmentVariableDefaultValue(@PathVariable Long projectId, @PathVariable Long environmentVariableId, @RequestBody EnvironmentVariableProjectValuePatch patch) {
        String defaultValue = this.environmentVariableValueService.resetDefaultValue(projectId, environmentVariableId, patch.getEntityType());
        return Collections.singletonMap("defaultValue", defaultValue);
    }
}

