/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.campaign;

import java.io.File;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.NodeReference;
import org.squashtest.tm.domain.NodeType;
import org.squashtest.tm.domain.NodeWorkspace;
import org.squashtest.tm.domain.campaign.Campaign;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.domain.campaign.export.CampaignExportCSVModel;
import org.squashtest.tm.service.campaign.CampaignFinder;
import org.squashtest.tm.service.campaign.CampaignLibraryNavigationService;
import org.squashtest.tm.service.campaign.IterationModificationService;
import org.squashtest.tm.service.deletion.CampaignLibraryNodesToDelete;
import org.squashtest.tm.service.deletion.OperationReport;
import org.squashtest.tm.service.deletion.SuppressionPreviewReport;
import org.squashtest.tm.service.display.workspace.tree.MultipleHierarchyTreeBrowser;
import org.squashtest.tm.service.display.workspace.tree.TreeBrowser;
import org.squashtest.tm.service.display.workspace.tree.TreeNodeCollectorService;
import org.squashtest.tm.service.internal.display.grid.DataRow;
import org.squashtest.tm.service.internal.display.grid.TreeGridResponse;
import org.squashtest.tm.service.internal.display.grid.TreeRequest;
import org.squashtest.tm.service.internal.utils.HTMLCleanupUtils;
import org.squashtest.tm.service.milestone.ActiveMilestoneHolder;
import org.squashtest.tm.web.backend.controller.campaign.CampaignLibraryNavigationController;
import org.squashtest.tm.web.backend.controller.form.model.CampaignFolderFormModel;
import org.squashtest.tm.web.backend.controller.form.model.CampaignFormModel;
import org.squashtest.tm.web.backend.controller.form.model.EntityFormModel;
import org.squashtest.tm.web.backend.controller.form.model.EntityFormModelValidator;
import org.squashtest.tm.web.backend.controller.form.model.IterationFormModel;
import org.squashtest.tm.web.backend.controller.form.model.NodeList;
import org.squashtest.tm.web.backend.controller.form.model.RefreshTreeNodeModel;
import org.squashtest.tm.web.backend.controller.form.model.TestSuiteFormModel;
import org.squashtest.tm.web.backend.controller.navigation.Messages;

@RestController
@RequestMapping(path={"backend/campaign-tree"})
public class CampaignLibraryNavigationController {
    public static final Logger LOGGER = LoggerFactory.getLogger(CampaignLibraryNavigationController.class);
    private static final String ADD_CAMPAIGN = "add-campaign";
    private static final String ADD_ITERATION = "add-iteration";
    private static final String ADD_CAMPAIGN_FOLDER = "add-campaign-folder";
    private static final String REMOVE_FROM_ITER = "remove_from_iter";
    private final TreeBrowser treeBrowser;
    private ActiveMilestoneHolder activeMilestoneHolder;
    private final CampaignLibraryNavigationService campaignLibraryNavigationService;
    private final TreeNodeCollectorService treeNodeCollectorService;
    private final IterationModificationService iterationModificationService;
    private final MessageSource messageSource;
    private final CampaignFinder campaignFinder;
    private static volatile /* synthetic */ int[] $SWITCH_TABLE$org$squashtest$tm$domain$EntityType;
    private static volatile /* synthetic */ int[] $SWITCH_TABLE$org$squashtest$tm$domain$NodeType;

    public CampaignLibraryNavigationController(MultipleHierarchyTreeBrowser treeBrowser, ActiveMilestoneHolder activeMilestoneHolder, CampaignLibraryNavigationService campaignLibraryNavigationService, TreeNodeCollectorService treeNodeCollectorService, IterationModificationService iterationModificationService, MessageSource messageSource, CampaignFinder campaignFinder) {
        this.treeBrowser = treeBrowser;
        this.activeMilestoneHolder = activeMilestoneHolder;
        this.campaignLibraryNavigationService = campaignLibraryNavigationService;
        this.treeNodeCollectorService = treeNodeCollectorService;
        this.iterationModificationService = iterationModificationService;
        this.messageSource = messageSource;
        this.campaignFinder = campaignFinder;
    }

    @RequestMapping(method={RequestMethod.POST})
    public TreeGridResponse getInitialRows(@RequestBody TreeRequest treeRequest) {
        return this.treeBrowser.getInitialTree(NodeWorkspace.CAMPAIGN, NodeReference.fromNodeIds((Collection)treeRequest.getOpenedNodes()), NodeReference.fromNodeIds((Collection)treeRequest.getSelectedNodes()));
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/{ids}/content"})
    public TreeGridResponse getChildren(@PathVariable List<String> ids) {
        Set nodeReference = NodeReference.fromNodeIds(ids);
        return this.treeBrowser.findSubHierarchy(nodeReference, new HashSet(nodeReference));
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/refresh"})
    public TreeGridResponse refreshNodes(@RequestBody RefreshTreeNodeModel refreshTreeNodeModel) {
        return this.treeBrowser.findSubHierarchy(NodeReference.fromNodeIds((Collection)refreshTreeNodeModel.getNodeIds()), new HashSet(refreshTreeNodeModel.getNodeList().getNodeReferences()));
    }

    /*
     * Exception decompiling
     */
    @ResponseBody
    @RequestMapping(value={"new-campaign"}, method={RequestMethod.POST}, consumes={"application/json"}, produces={"application/json"})
    public DataRow addNewCampaign(@RequestBody CampaignFormModel campaignFormModel) throws BindException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.entities.ClassFileField.getField()" because "fieldvar" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewriteEclipse(SwitchEnumRewriter.java:239)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewrite(SwitchEnumRewriter.java:153)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.rewrite(SwitchEnumRewriter.java:86)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:882)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @ResponseBody
    @RequestMapping(value={"campaign/{campaignId}/new-iteration"}, method={RequestMethod.POST}, consumes={"application/json"}, produces={"application/json"})
    public DataRow addNewIterationToCampaign(@PathVariable long campaignId, @RequestBody IterationFormModel iterationForm) throws BindException {
        this.validateFormModel((EntityFormModel)iterationForm, ADD_ITERATION);
        Iteration newIteration = iterationForm.getIteration();
        Map customFieldValues = iterationForm.getCufs();
        boolean copyTestPlan = iterationForm.isCopyTestPlan();
        this.campaignLibraryNavigationService.addIterationToCampaign(newIteration, campaignId, copyTestPlan, customFieldValues);
        return this.treeNodeCollectorService.collectNode(NodeType.ITERATION, (Identified)newIteration);
    }

    /*
     * Exception decompiling
     */
    @ResponseBody
    @RequestMapping(value={"new-folder"}, method={RequestMethod.POST}, consumes={"application/json"}, produces={"application/json"})
    public DataRow addNewFolder(@RequestBody CampaignFolderFormModel folderModel) throws BindException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.entities.ClassFileField.getField()" because "fieldvar" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewriteEclipse(SwitchEnumRewriter.java:239)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewrite(SwitchEnumRewriter.java:153)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.rewrite(SwitchEnumRewriter.java:86)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:882)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @ResponseBody
    @PostMapping(value={"new-test-suite"})
    public DataRow addTestSuite(@RequestBody TestSuiteFormModel suiteFormModel) {
        TestSuite suite = suiteFormModel.getTestSuite();
        Map customFieldValues = suiteFormModel.getCufs();
        String serializedParentEntityReference = suiteFormModel.getParentEntityReference();
        EntityReference parentEntityReference = EntityReference.fromNodeId((String)serializedParentEntityReference);
        this.campaignLibraryNavigationService.addTestSuiteToIteration(parentEntityReference.getId(), suite, customFieldValues);
        return this.treeNodeCollectorService.collectNode(NodeType.TEST_SUITE, (Identified)suite);
    }

    /*
     * Exception decompiling
     */
    @ResponseBody
    @RequestMapping(value={"/{destinationId}/content/paste"}, method={RequestMethod.POST})
    public void copyNodes(@RequestBody NodeList nodeList, @PathVariable(value="destinationId") String destinationId) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.entities.ClassFileField.getField()" because "fieldvar" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewriteEclipse(SwitchEnumRewriter.java:239)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewrite(SwitchEnumRewriter.java:153)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.rewrite(SwitchEnumRewriter.java:86)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:882)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @ResponseBody
    @RequestMapping(value={"/{destinationRef}/content/move"}, method={RequestMethod.POST})
    public void moveNodes(@RequestBody NodeList nodeList, @PathVariable(value="destinationRef") String destinationRef) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.entities.ClassFileField.getField()" because "fieldvar" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewriteEclipse(SwitchEnumRewriter.java:239)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewrite(SwitchEnumRewriter.java:153)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.rewrite(SwitchEnumRewriter.java:86)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:882)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @ResponseBody
    @RequestMapping(value={"/{destinationRef}/content/move/{position}"}, method={RequestMethod.POST})
    public void moveNodesAtPosition(@RequestBody NodeList nodeList, @PathVariable(value="destinationRef") String destinationRef, @PathVariable(value="position") int position) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.entities.ClassFileField.getField()" because "fieldvar" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewriteEclipse(SwitchEnumRewriter.java:239)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewrite(SwitchEnumRewriter.java:153)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.rewrite(SwitchEnumRewriter.java:86)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:882)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @ResponseBody
    @RequestMapping(value={"/deletion-simulation/{nodeIds}"}, method={RequestMethod.GET})
    public Messages simulateNodesDeletion(@PathVariable(value="nodeIds") List<String> nodeIds, Locale locale) {
        CampaignLibraryNodesToDelete deletionNodes = CampaignLibraryNodesToDelete.from(nodeIds);
        List folderAndCampaignIds = deletionNodes.getFolderAndCampaignNodeIds();
        Messages messages = new Messages();
        if (!folderAndCampaignIds.isEmpty()) {
            List reportList = this.campaignLibraryNavigationService.simulateDeletion(folderAndCampaignIds);
            for (SuppressionPreviewReport report : reportList) {
                messages.addMessage(report.toString(this.messageSource, locale));
            }
        }
        List reportIterationList = this.campaignLibraryNavigationService.simulateIterationDeletion(deletionNodes.getIterationIds());
        List reportSuiteList = this.campaignLibraryNavigationService.simulateSuiteDeletion(deletionNodes.getSuiteIds());
        for (SuppressionPreviewReport report : reportIterationList) {
            messages.addMessage(report.toString(this.messageSource, locale));
        }
        for (SuppressionPreviewReport report : reportSuiteList) {
            messages.addMessage(report.toString(this.messageSource, locale));
        }
        return messages;
    }

    @ResponseBody
    @RequestMapping(value={"/{nodeIds}"}, params={"remove_from_iter"}, method={RequestMethod.DELETE})
    public OperationReport confirmNodeDeletions(@PathVariable(value="nodeIds") List<String> nodeIds, @RequestParam(value="remove_from_iter") boolean removeFromIter) {
        CampaignLibraryNodesToDelete deletionNodes = CampaignLibraryNodesToDelete.from(nodeIds);
        return this.campaignLibraryNavigationService.deleteNodes(deletionNodes, removeFromIter);
    }

    @PostMapping(value={"campaign/{campaignId}/new-iteration-with-items"})
    @ResponseBody
    public void addIterationToCampaignWithItems(@PathVariable long campaignId, @RequestBody IterationCreation patch) {
        Iteration iteration = patch.getIteration();
        HashMap cufs = new HashMap();
        this.campaignLibraryNavigationService.addIterationToCampaignWithItems(iteration, campaignId, false, cufs, patch.getItemTestPlanIds());
    }

    @ResponseBody
    @RequestMapping(value={"/export-campaign/{campaignId}"}, method={RequestMethod.GET}, params={"export=csv"})
    public FileSystemResource exportCampaign(@PathVariable(value="campaignId") long campaignId, @RequestParam(value="exportType", defaultValue="S") String exportType, HttpServletResponse response) {
        Campaign campaign = this.campaignFinder.findById(campaignId);
        CampaignExportCSVModel model = this.campaignLibraryNavigationService.exportCampaignToCSV(Long.valueOf(campaignId), exportType);
        response.setContentType("application/octet-stream");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd_HHmmss");
        response.setHeader("Content-Disposition", "attachment; filename=EXPORT_CPG_" + exportType + "_" + campaign.getName().replace(" ", "_") + "_" + sdf.format(new Date()) + ".csv");
        File exported = this.exportToFile(model);
        return new FileSystemResource(exported);
    }

    private void validateCampaignFolderFormModel(CampaignFolderFormModel folderModel) throws BindException {
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)folderModel, ADD_CAMPAIGN_FOLDER);
        EntityFormModelValidator entityFormModelValidator = new EntityFormModelValidator();
        entityFormModelValidator.validate((Object)folderModel, (Errors)validation);
        if (validation.hasErrors()) {
            throw new BindException((BindingResult)validation);
        }
    }

    private void validateFormModel(EntityFormModel formModel, String objectName) throws BindException {
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)formModel, objectName);
        EntityFormModelValidator validator = new EntityFormModelValidator();
        validator.validate((Object)formModel, (Errors)validation);
        if (validation.hasErrors()) {
            throw new BindException((BindingResult)validation);
        }
    }

    private File exportToFile(CampaignExportCSVModel model) {
        try (PrintWriter writer = null;){
            File file = File.createTempFile("export-requirement", "tmp");
            file.deleteOnExit();
            writer = new PrintWriter(file);
            CampaignExportCSVModel.Row header = model.getHeader();
            writer.write(String.valueOf(header.toString()) + "\n");
            Iterator iterator = model.dataIterator();
            while (iterator.hasNext()) {
                CampaignExportCSVModel.Row datarow = (CampaignExportCSVModel.Row)iterator.next();
                String cleanRowValue = HTMLCleanupUtils.htmlToTrimmedText((String)datarow.toString()).replaceAll("\\n", "").replaceAll("\\r", "");
                writer.write(String.valueOf(cleanRowValue) + "\n");
            }
            writer.close();
            File file2 = file;
            return file2;
        }
    }

    static /* synthetic */ int[] $SWITCH_TABLE$org$squashtest$tm$domain$EntityType() {
        if ($SWITCH_TABLE$org$squashtest$tm$domain$EntityType != null) {
            return $SWITCH_TABLE$org$squashtest$tm$domain$EntityType;
        }
        int[] nArray = new int[EntityType.values().length];
        try {
            nArray[EntityType.ACTION_WORD.ordinal()] = 38;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.ACTION_WORD_LIBRARY.ordinal()] = 37;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.ATTACHMENT.ordinal()] = 26;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.ATTACHMENT_LIST.ordinal()] = 27;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.AUTOMATED_EXECUTION_EXTENDER.ordinal()] = 25;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.AUTOMATED_TEST.ordinal()] = 24;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.AUTOMATION_REQUEST.ordinal()] = 28;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.CAMPAIGN.ordinal()] = 13;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.CAMPAIGN_FOLDER.ordinal()] = 12;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.CAMPAIGN_LIBRARY.ordinal()] = 11;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.CHART_DEFINITION.ordinal()] = 34;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.CUSTOM_REPORT_CUSTOM_EXPORT.ordinal()] = 36;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.CUSTOM_REPORT_DASHBOARD.ordinal()] = 33;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.CUSTOM_REPORT_FOLDER.ordinal()] = 32;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.CUSTOM_REPORT_LIBRARY.ordinal()] = 31;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.DATASET.ordinal()] = 29;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.EXECUTION.ordinal()] = 15;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.EXECUTION_STEP.ordinal()] = 17;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.HIGH_LEVEL_REQUIREMENT.ordinal()] = 10;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.INFO_LIST_ITEM.ordinal()] = 21;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.ISSUE.ordinal()] = 19;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.ITEM_TEST_PLAN.ordinal()] = 20;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.ITERATION.ordinal()] = 14;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.MILESTONE.ordinal()] = 23;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.PARAMETER.ordinal()] = 30;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.PROJECT.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.REPORT_DEFINITION.ordinal()] = 35;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.REQUIREMENT.ordinal()] = 8;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.REQUIREMENT_FOLDER.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.REQUIREMENT_LIBRARY.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.REQUIREMENT_VERSION.ordinal()] = 9;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.SCM_REPOSITORY.ordinal()] = 39;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.TEST_CASE.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.TEST_CASE_FOLDER.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.TEST_CASE_LIBRARY.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.TEST_CASE_STEP.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.TEST_STEP.ordinal()] = 18;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.TEST_SUITE.ordinal()] = 16;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.USER.ordinal()] = 22;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$org$squashtest$tm$domain$EntityType = nArray;
        return nArray;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$org$squashtest$tm$domain$NodeType() {
        if ($SWITCH_TABLE$org$squashtest$tm$domain$NodeType != null) {
            return $SWITCH_TABLE$org$squashtest$tm$domain$NodeType;
        }
        int[] nArray = new int[NodeType.values().length];
        try {
            nArray[NodeType.ACTION_WORD.ordinal()] = 21;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NodeType.ACTION_WORD_LIBRARY.ordinal()] = 20;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NodeType.CAMPAIGN.ordinal()] = 10;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NodeType.CAMPAIGN_FOLDER.ordinal()] = 9;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NodeType.CAMPAIGN_LIBRARY.ordinal()] = 8;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NodeType.CHART_DEFINITION.ordinal()] = 15;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NodeType.CUSTOM_REPORT_CUSTOM_EXPORT.ordinal()] = 16;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NodeType.CUSTOM_REPORT_DASHBOARD.ordinal()] = 17;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NodeType.CUSTOM_REPORT_FOLDER.ordinal()] = 14;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NodeType.CUSTOM_REPORT_LIBRARY.ordinal()] = 13;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NodeType.HIGH_LEVEL_REQUIREMENT.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NodeType.ITERATION.ordinal()] = 11;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NodeType.REPORT_DEFINITION.ordinal()] = 18;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NodeType.REQUIREMENT.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NodeType.REQUIREMENT_FOLDER.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NodeType.REQUIREMENT_LIBRARY.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NodeType.TEST_CASE.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NodeType.TEST_CASE_FOLDER.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NodeType.TEST_CASE_LIBRARY.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NodeType.TEST_STEP.ordinal()] = 19;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NodeType.TEST_SUITE.ordinal()] = 12;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$org$squashtest$tm$domain$NodeType = nArray;
        return nArray;
    }
}

