/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.attachment;

import java.beans.PropertyEditor;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.HtmlUtils;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.attachment.Attachment;
import org.squashtest.tm.service.attachment.AttachmentManagerService;
import org.squashtest.tm.service.attachment.RawAttachment;
import org.squashtest.tm.service.display.attachment.AttachmentDisplayService;
import org.squashtest.tm.service.internal.display.dto.AttachmentDto;
import org.squashtest.tm.service.internal.display.dto.AttachmentListDto;
import org.squashtest.tm.web.backend.controller.attachment.UploadedData;
import org.squashtest.tm.web.backend.controller.attachment.UploadedDataPropertyEditorSupport;
import org.squashtest.tm.web.backend.fileupload.UploadContentFilterUtil;
import org.squashtest.tm.web.backend.fileupload.UploadSummary;

@RestController
@RequestMapping(value={"backend/attach-list/{attachListId}"})
public class AttachmentViewController {
    private static final String STR_UPLOAD_STATUS_OK = "dialog.attachment.summary.statusok.label";
    private static final String STR_UPLOAD_STATUS_WRONGFILETYPE = "dialog.attachment.summary.statuswrongtype.label";
    private static final Logger LOGGER = LoggerFactory.getLogger(AttachmentViewController.class);
    @Inject
    private AttachmentManagerService attachmentManagerService;
    @Inject
    private AttachmentDisplayService attachmentDisplayService;
    @Inject
    private MessageSource messageSource;
    @Inject
    private UploadContentFilterUtil filterUtil;

    @InitBinder
    public void initBinder(HttpServletRequest request, ServletRequestDataBinder binder) throws ServletException {
        binder.registerCustomEditor(UploadedData.class, (PropertyEditor)new UploadedDataPropertyEditorSupport());
    }

    @RequestMapping(method={RequestMethod.GET})
    public AttachmentListDto getAttachmentList(@PathVariable long attachListId) {
        return this.attachmentDisplayService.getAttachmentList(attachListId);
    }

    @RequestMapping(value={"/attachments/{attachmentIds}"}, method={RequestMethod.DELETE})
    public void removeAttachment(@PathVariable long attachListId, @PathVariable(value="attachmentIds") List<Long> attachmentIds, @RequestParam(value="entityId") long entityId, @RequestParam(value="entityType") String entityType) throws IOException {
        EntityReference entityRef = this.getEntityReference(entityType, entityId);
        this.attachmentManagerService.removeListOfAttachments(attachListId, attachmentIds, entityRef);
    }

    @RequestMapping(value={"/attachments/upload"}, method={RequestMethod.POST}, produces={"application/json"})
    public List<UploadSummary> uploadAttachmentAsJson(@RequestParam(value="attachment[]") List<UploadedData> attachments, @PathVariable long attachListId, @RequestParam(value="entityId") long entityId, @RequestParam(value="entityType") String entityType, Locale locale) throws IOException {
        LinkedList<UploadSummary> summary = new LinkedList<UploadSummary>();
        EntityReference entityRef = this.getEntityReference(entityType, entityId);
        for (UploadedData upload : attachments) {
            LOGGER.trace("AttachmentController : adding attachment " + upload.getName());
            boolean shouldProceed = this.filterUtil.isTypeAllowed(upload);
            if (!shouldProceed) {
                AttachmentDto refusedAttachmentDto = new AttachmentDto();
                refusedAttachmentDto.setName(HtmlUtils.htmlEscape((String)upload.getName()));
                summary.add(new UploadSummary(refusedAttachmentDto, this.getUploadSummary(STR_UPLOAD_STATUS_WRONGFILETYPE, locale), 1));
                continue;
            }
            AttachmentDto newAttachmentDto = this.attachmentManagerService.addAttachment(attachListId, (RawAttachment)upload, entityRef);
            summary.add(new UploadSummary(newAttachmentDto, this.getUploadSummary(STR_UPLOAD_STATUS_OK, locale), 0));
        }
        return summary;
    }

    @ResponseBody
    @RequestMapping(value={"/attachments/download/{attachemendId}"}, method={RequestMethod.GET})
    public void downloadAttachment(@PathVariable(value="attachemendId") long attachmentId, HttpServletResponse response) {
        try {
            Attachment attachment = this.attachmentManagerService.findAttachment(Long.valueOf(attachmentId));
            response.setContentType("application/octet-stream");
            response.setHeader("Content-Disposition", "attachment; filename=" + attachment.getName().replace(" ", "_"));
            ServletOutputStream outStream = response.getOutputStream();
            this.attachmentManagerService.writeContent(attachmentId, (OutputStream)outStream);
        }
        catch (IOException e) {
            LOGGER.warn("Error happened during attachment download : " + e.getMessage(), (Throwable)e);
            response.setStatus(500);
        }
    }

    private String getUploadSummary(String key, Locale locale) {
        return this.messageSource.getMessage(key, null, locale);
    }

    private EntityReference getEntityReference(String entityType, long entityId) {
        String className = StringUtils.capitalize((String)entityType);
        EntityType type = EntityType.fromSimpleName((String)className);
        return new EntityReference(type, Long.valueOf(entityId));
    }
}

