/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.i18n;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.NoSuchMessageException;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Component;
import org.squashtest.tm.core.foundation.i18n.Abbreviated;
import org.squashtest.tm.core.foundation.i18n.Internationalizable;
import org.squashtest.tm.web.i18n.MessageObject;

@Component
@Primary
public class InternationalizationHelper
implements MessageSource {
    private final MessageSource messageSource;

    @Inject
    public InternationalizationHelper(@NotNull MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public String internationalize(String i18nKey, Locale locale) {
        return this.messageSource.getMessage(i18nKey, null, locale);
    }

    public String internationalize(Internationalizable internationalizable, Locale locale) {
        return this.internationalize(internationalizable.getI18nKey(), locale);
    }

    public String internationalizeAbbreviation(Abbreviated abridged, Locale locale) {
        return this.internationalize(abridged.getAbbreviatedI18nKey(), locale);
    }

    public String localizeDate(Date date, Locale locale) {
        String formatKey = "squashtm.dateformat";
        return this.localizeDate(date, locale, formatKey);
    }

    public String localizeShortDate(Date date, Locale locale) {
        String formatKey = "squashtm.dateformatShort";
        return this.localizeDate(date, locale, formatKey);
    }

    private String localizeDate(Date date, Locale locale, String formatKey) {
        if (date == null) {
            return this.noData(locale);
        }
        String format = this.messageSource.getMessage(formatKey, null, locale);
        return new SimpleDateFormat(format).format(date);
    }

    public String getMessage(String code, Object[] args, String defaultMessage, Locale locale) {
        return this.messageSource.getMessage(code, args, defaultMessage, locale);
    }

    @Deprecated
    public String getMessage(String code, Object[] args, Locale locale) throws NoSuchMessageException {
        return this.messageSource.getMessage(code, args, locale);
    }

    public String getMessage(MessageSourceResolvable resolvable, Locale locale) throws NoSuchMessageException {
        return this.messageSource.getMessage(resolvable, locale);
    }

    public void resolve(MessageObject object, Locale locale) {
        this.processAsMap((Map)object, locale);
    }

    private void processAsMap(Map<String, Object> object, Locale locale) {
        for (Map.Entry<String, Object> entry : object.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof String) {
                String translation = this.processAsString((String)value, locale);
                entry.setValue(translation);
                continue;
            }
            if (value instanceof Map) {
                this.processAsMap((Map)value, locale);
                continue;
            }
            throw new IllegalArgumentException("InternationalizationHelper : supplied MessageObject contained data that where neither String nor Map. Got : '" + value.getClass() + "'");
        }
    }

    private String processAsString(String key, Locale locale) {
        return this.messageSource.getMessage(key, null, locale);
    }

    public String internationalizeYesNo(boolean yesOrNo, Locale locale) {
        return this.internationalize("squashtm.yesno." + yesOrNo, locale);
    }

    public String noData(Locale locale) {
        return this.internationalize("squashtm.nodata", locale);
    }

    public String itemDeleted(Locale locale) {
        return this.internationalize("squashtm.itemdeleted", locale);
    }

    public String messageOrNoData(String message, Locale locale) {
        return message != null ? message : this.noData(locale);
    }

    public String localizeDateWithDefaultToNever(Date date, Locale locale) {
        String strDate = date != null ? this.localizeDate(date, locale) : this.internationalize("label.lower.Never", locale);
        return strDate;
    }
}

