/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.security.authentication;

import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.security.authentication.event.AuthenticationSuccessEvent;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.provisioning.UserDetailsManager;
import org.squashtest.tm.api.security.authentication.AuthenticationProviderFeatures;
import org.squashtest.tm.api.security.authentication.ExtraAccountInformationAuthentication;
import org.squashtest.tm.domain.users.User;
import org.squashtest.tm.exception.user.LoginAlreadyExistsException;
import org.squashtest.tm.service.internal.security.AuthenticationProviderContext;
import org.squashtest.tm.service.user.UserAdministrationService;
import org.squashtest.tm.web.backend.context.ApplicationComponent;

@ApplicationComponent
public class AuthenticatedMissingUserCreator
implements ApplicationListener<AuthenticationSuccessEvent>,
Ordered {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthenticatedMissingUserCreator.class);
    @Inject
    private AuthenticationProviderContext authProviderContext;
    @Inject
    private UserAdministrationService userAccountManager;
    @Inject
    private UserDetailsManager userDetailsManager;

    public AuthenticatedMissingUserCreator() {
        LOGGER.info("created");
    }

    public int getOrder() {
        return -2147483647;
    }

    public void onApplicationEvent(AuthenticationSuccessEvent event) {
        AuthenticationProviderFeatures features = this.authProviderContext.getProviderFeatures(event.getAuthentication());
        if (features.shouldCreateMissingUser()) {
            this.createMissingUser(event.getAuthentication());
        }
    }

    private void createMissingUser(Authentication principal) {
        LOGGER.debug("Will try to create user from principal if it does not exist");
        try {
            this.userAccountManager.checkLoginAvailability(principal.getName());
        }
        catch (LoginAlreadyExistsException loginAlreadyExistsException) {
            return;
        }
        LOGGER.info("Authenticated principal does not match any User, a new User will be created");
        this.createUserFromPrincipal(principal);
    }

    private void createUserFromPrincipal(Authentication principal) {
        try {
            this.createUserAccount(principal);
            this.createSpringSecAccount(principal);
        }
        catch (LoginAlreadyExistsException e) {
            LOGGER.warn("Something went wrong while trying to create missing authenticated user", (Throwable)e);
        }
    }

    private void createUserAccount(Authentication principal) {
        String username = principal.getName().trim();
        LOGGER.debug("creating user : ", (Object)username);
        User user = User.createFromLogin((String)username);
        if (ExtraAccountInformationAuthentication.class.isAssignableFrom(principal.getClass())) {
            LOGGER.debug("Extra account information were found in the principal : the user account will be populated with them");
            ExtraAccountInformationAuthentication extra = (ExtraAccountInformationAuthentication)principal;
            user.setFirstName(extra.getFirstName());
            user.setEmail(extra.getEmail());
            String lastName = extra.getLastName();
            if (!StringUtils.isBlank((CharSequence)lastName)) {
                user.setLastName(extra.getLastName());
            }
        }
        this.userAccountManager.createUserWithoutCredentials(user, "squashtest.authz.group.tm.User");
    }

    private void createSpringSecAccount(Authentication principal) {
        String username = principal.getName().trim();
        List<SimpleGrantedAuthority> authorities = Arrays.asList(new SimpleGrantedAuthority("ROLE_TM_USER"));
        org.springframework.security.core.userdetails.User springUser = new org.springframework.security.core.userdetails.User(username, "", authorities);
        this.userDetailsManager.createUser((UserDetails)springUser);
    }
}

