/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.listener;

import javax.inject.Inject;
import org.apache.logging.log4j.util.Strings;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.squashtest.tm.service.configuration.ConfigurationService;
import org.squashtest.tm.web.backend.context.ApplicationComponent;

@ApplicationComponent
public class ApplicationReadyListener
implements ApplicationListener<ApplicationReadyEvent> {
    @Value(value="${tm.test.automation.server.callbackurl}")
    private String callbackUrlFromConfFile;
    @Inject
    private ConfigurationService configurationService;

    public void onApplicationEvent(ApplicationReadyEvent event) {
        this.copySquashPublicUrlFromConfFileIntoDatabase();
    }

    private void copySquashPublicUrlFromConfFileIntoDatabase() {
        String callbackUrlFromDatabase = this.configurationService.findConfiguration("squashtest.tm.callbackurl");
        if (Strings.isBlank((String)callbackUrlFromDatabase) && !Strings.isBlank((String)this.callbackUrlFromConfFile)) {
            this.configurationService.set("squashtest.tm.callbackurl", this.callbackUrlFromConfFile);
        }
    }
}

