/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.test.automation.server.environments.unrestricted;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.domain.environmenttag.AutomationEnvironmentTag;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.domain.servers.TokenAuthCredentials;
import org.squashtest.tm.service.display.test.automation.server.TestAutomationServerDisplayService;
import org.squashtest.tm.service.internal.display.dto.automatedexecutionenvironments.EnvironmentSelectionPanelDto;
import org.squashtest.tm.service.project.GenericProjectFinder;
import org.squashtest.tm.service.servers.StoredCredentialsManager;
import org.squashtest.tm.service.testautomation.environment.AutomatedExecutionEnvironmentService;
import org.squashtest.tm.service.testautomation.spi.TestAutomationException;
import org.squashtest.tm.web.backend.controller.form.model.StringList;
import org.squashtest.tm.web.backend.controller.test.automation.server.environments.AbstractTAEnvironmentsController;

@Controller
@RequestMapping(value={"/backend/test-automation/"})
public class UnrestrictedTAEnvironmentsController
extends AbstractTAEnvironmentsController {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnrestrictedTAEnvironmentsController.class);
    private final TestAutomationServerDisplayService testAutomationServerDisplayService;
    private final GenericProjectFinder genericProjectFinder;

    protected UnrestrictedTAEnvironmentsController(AutomatedExecutionEnvironmentService automatedExecutionEnvironmentService, TestAutomationServerDisplayService testAutomationServerDisplayService, GenericProjectFinder genericProjectFinder, StoredCredentialsManager storedCredentialsManager) {
        super(automatedExecutionEnvironmentService, storedCredentialsManager);
        this.testAutomationServerDisplayService = testAutomationServerDisplayService;
        this.genericProjectFinder = genericProjectFinder;
    }

    @ResponseBody
    @GetMapping(value={"{projectId}/available-tags"})
    public StringList getAvailableProjectEnvironmentTags(@PathVariable Long projectId) {
        GenericProject project = Objects.requireNonNull(this.genericProjectFinder.findById(projectId.longValue()), String.format("Could not find a project with ID %d.", projectId));
        Objects.requireNonNull(project.getTestAutomationServer(), String.format("Expect project with ID %d to have a test automation server bound.", projectId));
        Long testAutomationServerId = project.getTestAutomationServer().getId();
        Optional optionalProjectToken = this.findProjectToken(testAutomationServerId, projectId);
        List environments = this.getAutomatedExecutionEnvironments(testAutomationServerId, (TokenAuthCredentials)optionalProjectToken.orElse(null));
        return new StringList(this.extractAllTags(environments));
    }

    @ResponseBody
    @GetMapping(value={"{projectId}/automated-execution-environments/all"})
    public EnvironmentSelectionPanelDto getProjectEnvironmentsPanel(@PathVariable Long projectId) {
        GenericProject project = Objects.requireNonNull(this.genericProjectFinder.findById(projectId.longValue()), String.format("Could not find a project with ID %d.", projectId));
        Objects.requireNonNull(project.getTestAutomationServer(), String.format("Expect project with ID %d to have a test automation server bound.", projectId));
        Long testAutomationServerId = project.getTestAutomationServer().getId();
        boolean hasServerToken = this.testAutomationServerDisplayService.hasDefinedCredentials(testAutomationServerId.longValue());
        Optional optionalProjectToken = this.findProjectToken(testAutomationServerId, projectId);
        boolean hasProjectToken = optionalProjectToken.isPresent();
        if (hasServerToken || hasProjectToken) {
            return this.getProjectEnvironmentPanelResponse(projectId, project, testAutomationServerId, optionalProjectToken, hasServerToken, hasProjectToken);
        }
        return EnvironmentSelectionPanelDto.forProjectWithoutCredentials((Long)testAutomationServerId, (Long)projectId);
    }

    private EnvironmentSelectionPanelDto getProjectEnvironmentPanelResponse(Long projectId, GenericProject project, Long testAutomationServerId, Optional<TokenAuthCredentials> optionalProjectToken, boolean hasServerCredentials, boolean hasProjectToken) {
        List allAccessibleEnvironments;
        boolean areProjectTagsInherited;
        List projectTags;
        List defaultTags;
        block2: {
            defaultTags = this.testAutomationServerDisplayService.getDefaultEnvironmentTags(testAutomationServerId.longValue());
            projectTags = project.getEnvironmentTags().stream().map(AutomationEnvironmentTag::getValue).collect(Collectors.toList());
            areProjectTagsInherited = project.isInheritsEnvironmentTags();
            allAccessibleEnvironments = null;
            try {
                allAccessibleEnvironments = this.getAutomatedExecutionEnvironments(testAutomationServerId, (TokenAuthCredentials)optionalProjectToken.orElse(null));
            }
            catch (TestAutomationException ex) {
                if (!LOGGER.isTraceEnabled()) break block2;
                LOGGER.trace(String.format("Could not fetch available automated execution environments for project %d.", projectId), (Throwable)ex);
            }
        }
        return EnvironmentSelectionPanelDto.forProject((Long)testAutomationServerId, (List)defaultTags, (boolean)hasServerCredentials, (List)allAccessibleEnvironments, (Long)projectId, (boolean)hasProjectToken, projectTags, (boolean)areProjectTagsInherited);
    }
}

