/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.test.automation.server.environments;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.squashtest.tm.domain.servers.Credentials;
import org.squashtest.tm.domain.servers.TokenAuthCredentials;
import org.squashtest.tm.service.servers.StoredCredentialsManager;
import org.squashtest.tm.service.testautomation.environment.AutomatedExecutionEnvironmentService;
import org.squashtest.tm.service.testautomation.model.AutomatedExecutionEnvironment;

public abstract class AbstractTAEnvironmentsController {
    private final AutomatedExecutionEnvironmentService automatedExecutionEnvironmentService;
    private final StoredCredentialsManager storedCredentialsManager;

    protected AbstractTAEnvironmentsController(AutomatedExecutionEnvironmentService automatedExecutionEnvironmentService, StoredCredentialsManager storedCredentialsManager) {
        this.automatedExecutionEnvironmentService = automatedExecutionEnvironmentService;
        this.storedCredentialsManager = storedCredentialsManager;
    }

    protected List<String> extractAllTags(List<AutomatedExecutionEnvironment> environments) {
        return environments.stream().map(AutomatedExecutionEnvironment::getTags).flatMap(Collection::stream).distinct().sorted().collect(Collectors.toList());
    }

    protected List<AutomatedExecutionEnvironment> getAutomatedExecutionEnvironments(Long testAutomationServerId, TokenAuthCredentials optionalProjectToken) {
        return optionalProjectToken != null ? this.automatedExecutionEnvironmentService.getAllAccessibleEnvironments(testAutomationServerId, (Credentials)optionalProjectToken) : this.automatedExecutionEnvironmentService.getAllAccessibleEnvironments(testAutomationServerId);
    }

    protected Optional<TokenAuthCredentials> findProjectToken(Long testAutomationServerId, Long projectId) {
        return Optional.ofNullable(this.storedCredentialsManager.findProjectCredentials(testAutomationServerId.longValue(), projectId.longValue())).filter(credentials -> credentials instanceof TokenAuthCredentials).map(credentials -> (TokenAuthCredentials)credentials);
    }
}

