/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.system;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.service.actionword.ActionWordLibraryNodeService;
import org.squashtest.tm.service.feature.FeatureManager;
import org.squashtest.tm.service.internal.display.dto.SystemViewDto;
import org.squashtest.tm.service.system.SystemAdministrationService;
import org.squashtest.tm.service.user.UserManagerService;

@RestController
@RequestMapping(value={"/backend/system-view"})
public class SystemViewController {
    private static final Logger LOGGER = LoggerFactory.getLogger(SystemViewController.class);
    private final SystemAdministrationService systemAdministrationService;
    private final FeatureManager featureManager;
    private final UserManagerService userManagerService;
    private final ActionWordLibraryNodeService actionWordLibraryNodeService;
    private final Environment environment;
    @Value(value="${logging.dir}")
    private String loggingPath;
    @Value(value="${info.app.version}")
    private String appVersion;
    @Value(value="${squashtm.stack.trace.control.panel.visible:false}")
    private Boolean stackTracePanelIsVisible;

    SystemViewController(SystemAdministrationService administrationService, FeatureManager featureManager, UserManagerService userManagerService, Environment environment, ActionWordLibraryNodeService actionWordLibraryNodeService) {
        this.systemAdministrationService = administrationService;
        this.featureManager = featureManager;
        this.userManagerService = userManagerService;
        this.environment = environment;
        this.actionWordLibraryNodeService = actionWordLibraryNodeService;
    }

    @GetMapping
    public SystemViewDto getSystemView() {
        SystemViewDto dto = new SystemViewDto();
        dto.setStatistics(this.systemAdministrationService.findAdministrationStatistics());
        dto.setAppVersion(this.appVersion);
        dto.setPlugins(this.systemAdministrationService.findAllPluginsFilesOnInstance());
        dto.setWhiteList(this.systemAdministrationService.findWhiteList());
        dto.setUploadSizeLimit(this.systemAdministrationService.findUploadSizeLimit());
        dto.setImportSizeLimit(this.systemAdministrationService.findImportSizeLimit());
        dto.setCallbackUrl(this.systemAdministrationService.findCallbackUrl());
        dto.setStackTracePanelIsVisible(this.stackTracePanelIsVisible.booleanValue());
        dto.setStackTraceFeatureIsEnabled(this.featureManager.isEnabled(FeatureManager.Feature.STACK_TRACE));
        dto.setAutoconnectOnConnection(this.featureManager.isEnabled(FeatureManager.Feature.AUTOCONNECT_ON_CONNECTION));
        dto.setCaseInsensitiveLogin(this.featureManager.isEnabled(FeatureManager.Feature.CASE_INSENSITIVE_LOGIN));
        dto.setDuplicateLogins(this.userManagerService.findAllDuplicateLogins());
        dto.setCaseInsensitiveActions(this.featureManager.isEnabled(FeatureManager.Feature.CASE_INSENSITIVE_ACTIONS));
        dto.setDuplicateActions(this.actionWordLibraryNodeService.findAllCaseInsensitiveDuplicateActions());
        dto.setWelcomeMessage(this.systemAdministrationService.findWelcomeMessage());
        dto.setLoginMessage(this.systemAdministrationService.findLoginMessage());
        dto.setLogFiles(this.getAllLogFileNames());
        dto.setLicenseInfo(this.systemAdministrationService.getBasicLicenseInfo());
        return dto;
    }

    @GetMapping(value={"/current-active-users-count"})
    @ResponseBody
    public Map<String, Integer> getCurrentActiveUsersCount() {
        HashMap<String, Integer> responseBody = new HashMap<String, Integer>();
        int currentActiveUsersCount = this.userManagerService.countAllActiveUsersAssignedToAtLeastOneProject();
        responseBody.put("currentActiveUsersCount", currentActiveUsersCount);
        return responseBody;
    }

    private List<String> getAllLogFileNames() {
        if (Arrays.asList(this.environment.getActiveProfiles()).contains("dev")) {
            return new ArrayList<String>();
        }
        return this.findAllLogFiles().stream().map(File::getName).collect(Collectors.toList());
    }

    private List<File> findAllLogFiles() {
        File logsFolder = new File(this.loggingPath);
        if (!logsFolder.exists() || !logsFolder.isDirectory()) {
            LOGGER.warn("Logs path '{}' is not a readable folder. There will be no log files", (Object)logsFolder.getAbsolutePath());
            return new ArrayList<File>();
        }
        LOGGER.info("Enumerating log files in folder '{}'", (Object)logsFolder.getAbsolutePath());
        File[] logFiles = logsFolder.listFiles((dir, name) -> name.startsWith("squash-tm.log."));
        if (logFiles != null) {
            return Arrays.stream(logFiles).collect(Collectors.toList());
        }
        return new ArrayList<File>();
    }
}

