/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.project;

import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.validation.Valid;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.domain.project.ProjectTemplate;
import org.squashtest.tm.exception.NameAlreadyInUseException;
import org.squashtest.tm.service.project.ProjectTemplateManagerService;
import org.squashtest.tm.web.backend.model.json.JsonTemplateFromProject;

@RestController
@RequestMapping(value={"/backend/project-templates"})
public class ProjectTemplateController {
    private ProjectTemplateManagerService projectTemplateManagerService;

    @Inject
    ProjectTemplateController(ProjectTemplateManagerService projectTemplateManagerService) {
        this.projectTemplateManagerService = projectTemplateManagerService;
    }

    @ResponseBody
    @ResponseStatus(value=HttpStatus.CREATED)
    @RequestMapping(value={"/new"}, method={RequestMethod.POST})
    public Map<String, Object> createTemplateFromProject(@Valid @RequestBody JsonTemplateFromProject jsonTemplateFromProject) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        try {
            ProjectTemplate projectTemplate = this.projectTemplateManagerService.addTemplateFromProject(jsonTemplateFromProject.getProjectTemplate(), jsonTemplateFromProject.getTemplateId(), jsonTemplateFromProject.getParams());
            response.put("id", projectTemplate.getId());
        }
        catch (NameAlreadyInUseException ex) {
            ex.setObjectName("add-template-from-project");
            throw ex;
        }
        return response;
    }
}

