/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.project;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.api.plugin.ConfigurablePlugin;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.domain.testautomation.TestAutomationProject;
import org.squashtest.tm.service.display.project.ProjectDisplayService;
import org.squashtest.tm.service.internal.display.dto.PartyProjectPermissionDto;
import org.squashtest.tm.service.internal.display.dto.ProjectViewDto;
import org.squashtest.tm.service.internal.display.dto.TestAutomationProjectDto;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.grid.GridResponse;
import org.squashtest.tm.service.project.CustomGenericProjectManager;
import org.squashtest.tm.service.project.GenericProjectManagerService;
import org.squashtest.tm.service.testautomation.TestAutomationProjectManagerService;
import org.squashtest.tm.web.backend.controller.project.GenericProjectController;
import org.squashtest.tm.web.backend.manager.plugin.ConfigurablePluginManager;

@Controller
@RequestMapping(value={"/backend/generic-projects"})
public class GenericProjectController {
    private ProjectDisplayService projectDisplayService;
    private final CustomGenericProjectManager projectManagerService;
    private GenericProjectManagerService projectManager;
    private TaskExecutor taskExecutor;
    private TestAutomationProjectManagerService testAutomationProjectService;
    private final ConfigurablePluginManager configurablePluginManager;

    @Inject
    public GenericProjectController(ProjectDisplayService projectDisplayService, GenericProjectManagerService projectManager, CustomGenericProjectManager projectManagerService, TaskExecutor taskExecutor, TestAutomationProjectManagerService testAutomationProjectService, ConfigurablePluginManager configurablePluginManager) {
        this.projectDisplayService = projectDisplayService;
        this.projectManager = projectManager;
        this.projectManagerService = projectManagerService;
        this.taskExecutor = taskExecutor;
        this.testAutomationProjectService = testAutomationProjectService;
        this.configurablePluginManager = configurablePluginManager;
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.POST})
    public GridResponse getProjects(@RequestBody GridRequest request) {
        return this.projectDisplayService.findAll(request);
    }

    @ResponseBody
    @RequestMapping(value={"/templates"}, method={RequestMethod.GET})
    public Map<String, Object> getTemplates() {
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("templates", this.projectDisplayService.getTemplateNamedReferences());
        return response;
    }

    @ResponseBody
    @RequestMapping(value={"/{projectId}/permissions/{partyIds}/group"}, method={RequestMethod.POST})
    public Map<String, List<PartyProjectPermissionDto>> addNewPartyPermissions(@PathVariable long projectId, @PathVariable List<Long> partyIds, @RequestBody Map<String, String> request) {
        this.projectManagerService.addNewPermissionToProject(partyIds, projectId, request.get("group"));
        return Collections.singletonMap("partyProjectPermissions", this.projectDisplayService.getPartyProjectPermissions(Long.valueOf(projectId)));
    }

    @ResponseBody
    @RequestMapping(value={"/{projectId}/permissions/{partyIds}"}, method={RequestMethod.DELETE})
    public void removePartyPermissions(@PathVariable long projectId, @PathVariable List<Long> partyIds) {
        this.projectManagerService.removeProjectPermission(partyIds, projectId);
    }

    @RequestMapping(value={"/{projectId}/bugtracker"}, method={RequestMethod.POST})
    @ResponseBody
    public void changeBugtracker(@PathVariable long projectId, @RequestBody Map<String, Long> request) {
        if (request.get("bugtrackerId") != null) {
            this.projectManager.changeBugTracker(projectId, request.get("bugtrackerId"));
        } else {
            this.projectManager.removeBugTracker(projectId);
        }
    }

    @RequestMapping(value={"/{projectId}/bugtracker/projectNames"}, method={RequestMethod.GET})
    @ResponseBody
    public Map<String, Object> getBugtrackerProjectNames(@PathVariable long projectId) {
        GenericProject project = this.projectManager.findById(projectId);
        HashMap<String, Object> response = new HashMap<String, Object>();
        if (project.isBugtrackerConnected()) {
            response.put("projectNames", project.getBugtrackerBinding().getProjectNames());
        }
        return response;
    }

    @RequestMapping(value={"/{projectId}/bugtracker/projectNames"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> changeBugtrackerProjectName(@RequestBody List<String> projectBugTrackerNames, @PathVariable long projectId) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        this.projectManager.changeBugTrackerProjectName(projectId, projectBugTrackerNames);
        response.put("projectNames", projectBugTrackerNames);
        return response;
    }

    @RequestMapping(value={"/{projectId}/name"}, method={RequestMethod.POST})
    @ResponseBody
    public void changeName(@PathVariable long projectId, @RequestBody ProjectPatch patch) {
        this.projectManager.changeName(projectId, patch.getName());
    }

    @RequestMapping(value={"/{projectId}/description"}, method={RequestMethod.POST})
    @ResponseBody
    public void changeDescription(@PathVariable long projectId, @RequestBody ProjectPatch patch) {
        this.projectManager.changeDescription(projectId, patch.getDescription());
    }

    @RequestMapping(value={"/{projectId}/label"}, method={RequestMethod.POST})
    @ResponseBody
    public void changeLabel(@PathVariable long projectId, @RequestBody ProjectPatch patch) {
        this.projectManager.changeLabel(projectId, patch.getLabel());
    }

    @PostMapping(value={"/{projectId}/linked-template-id"})
    @ResponseBody
    public Map<String, Object> associateTemplate(@PathVariable long projectId, @RequestBody ProjectPatch patch) {
        Long templateId = patch.getLinkedTemplateId();
        HashMap<String, Object> response = new HashMap<String, Object>();
        if (templateId == null) {
            this.projectManager.disassociateFromTemplate(projectId);
            response.put("templateName", null);
        } else {
            ProjectViewDto linkedTemplate = this.projectDisplayService.getProjectView(templateId.longValue());
            this.projectManager.associateToTemplate(projectId, templateId.longValue(), patch.getBoundTemplatePlugins());
            response.put("templateName", linkedTemplate.getName());
        }
        return response;
    }

    @PostMapping(value={"/{projectId}/automation-workflow-type"})
    @ResponseBody
    public void changeAutomationWorkflowType(@PathVariable long projectId, @RequestBody ProjectPatch patch) {
        this.projectManager.changeAutomationWorkflow(projectId, patch.getAutomationWorkflowType());
    }

    @PostMapping(value={"/{projectId}/bdd-implementation-technology"})
    @ResponseBody
    public void changeBddImplementationTechnology(@PathVariable long projectId, @RequestBody ProjectPatch patch) {
        this.projectManager.changeBddImplTechnology(projectId, patch.getBddImplementationTechnology());
    }

    @PostMapping(value={"/{projectId}/bdd-script-language"})
    @ResponseBody
    public void changeBddScriptLanguage(@PathVariable long projectId, @RequestBody ProjectPatch patch) {
        this.projectManager.changeBddScriptLanguage(projectId, patch.getBddScriptLanguage());
    }

    @PostMapping(value={"/{projectId}/scm-repository-id"})
    @ResponseBody
    public void changeScmServer(@PathVariable long projectId, @RequestBody ProjectPatch patch) {
        Long repositoryId = patch.getScmRepositoryId();
        if (repositoryId == null) {
            this.projectManager.unbindScmRepository(projectId);
        } else {
            this.projectManager.bindScmRepository(projectId, repositoryId.longValue());
        }
    }

    @PostMapping(value={"/{projectId}/use-tree-structure-in-scm-repo"})
    @ResponseBody
    public void changeUseTreeStructureInScmRepo(@PathVariable long projectId, @RequestBody ProjectPatch patch) {
        this.projectManager.changeUseTreeStructureInScmRepo(projectId, patch.isUseTreeStructureInScmRepo());
    }

    @PostMapping(value={"/{projectId}/ta-server-id"})
    @ResponseBody
    public void changeTestAutomationServer(@PathVariable long projectId, @RequestBody ProjectPatch patch) {
        this.projectManager.bindTestAutomationServer(projectId, patch.getTaServerId());
    }

    @PostMapping(value={"/{projectId}/automated-suites-lifetime"})
    @ResponseBody
    public void changeAutomatedSuitesLifetime(@PathVariable long projectId, @RequestBody ProjectPatch patch) {
        this.projectManager.changeAutomatedSuitesLifetime(projectId, patch.getAutomatedSuitesLifetime());
    }

    @PostMapping(value={"/{projectId}/test-automation-projects/new"})
    @ResponseBody
    public Map<String, List<TestAutomationProjectDto>> addTestAutomationProject(@PathVariable long projectId, @RequestBody Map<String, TestAutomationProjectDto[]> request) {
        List taProjects = Arrays.stream(request.get("taProjects")).map(projectDto -> {
            TestAutomationProject taProject = new TestAutomationProject();
            taProject.setJobName(projectDto.getRemoteName());
            taProject.setCanRunGherkin(projectDto.isCanRunBdd());
            taProject.setLabel(projectDto.getLabel());
            return taProject;
        }).collect(Collectors.toList());
        this.projectManager.bindTestAutomationProjects(projectId, taProjects);
        return Collections.singletonMap("taProjects", this.testAutomationProjectService.findAllByTMProject(projectId));
    }

    @RequestMapping(value={"/{projectId}/allow-tc-modif-during-exec"})
    @ResponseBody
    public void changeAllowTcModifDuringExec(@PathVariable long projectId, @RequestBody ProjectPatch patch) {
        this.projectManager.changeAllowTcModifDuringExec(projectId, patch.isAllowTcModifDuringExec());
    }

    @RequestMapping(value={"/{projectId}/change-execution-status/{executionStatus}"}, method={RequestMethod.POST})
    @ResponseBody
    public void changeExecutionStatusOnProject(@PathVariable long projectId, @PathVariable String executionStatus, @RequestBody Map<String, Boolean> patch) {
        if (patch.get(executionStatus.toUpperCase()).booleanValue()) {
            this.projectManager.enableExecutionStatus(projectId, ExecutionStatus.valueOf((String)executionStatus));
        } else {
            this.projectManager.disableExecutionStatus(projectId, ExecutionStatus.valueOf((String)executionStatus));
        }
    }

    @RequestMapping(value={"/{projectId}/disable-and-replace-execution-status-within-project/{sourceExecutionStatus}"}, method={RequestMethod.POST})
    @ResponseBody
    public void disableAndReplaceStatusWithinProject(@PathVariable long projectId, @PathVariable String sourceExecutionStatus, @RequestBody Map<String, String> targetExecutionStatus) {
        this.projectManager.disableExecutionStatus(projectId, ExecutionStatus.valueOf((String)sourceExecutionStatus));
        ExecutionStatus source = ExecutionStatus.valueOf((String)sourceExecutionStatus);
        ExecutionStatus target = ExecutionStatus.valueOf((String)targetExecutionStatus.get("targetExecutionStatus"));
        AsynchronousReplaceExecutionStatus replacer = new AsynchronousReplaceExecutionStatus(this, Long.valueOf(projectId), source, target);
        this.taskExecutor.execute((Runnable)replacer);
    }

    @RequestMapping(value={"/{projectId}/get-enabled-execution-status/{executionStatus}"}, method={RequestMethod.GET})
    @ResponseBody
    public Map<String, Object> getEnabledExecutionStatus(@PathVariable long projectId, @PathVariable String executionStatus) {
        Set statuses = this.projectManager.enabledExecutionStatuses(projectId);
        ExecutionStatus status = ExecutionStatus.valueOf((String)executionStatus);
        statuses.remove(status);
        ArrayList options = new ArrayList();
        for (ExecutionStatus st : statuses) {
            HashMap<String, String> statusOption = new HashMap<String, String>();
            statusOption.put("label", st.getI18nKey());
            statusOption.put("id", st.name());
            options.add(statusOption);
        }
        return Collections.singletonMap("statuses", options);
    }

    @RequestMapping(value={"/{projectId}/plugins/{pluginId}"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Boolean> enablePlugin(@PathVariable long projectId, @PathVariable String pluginId) {
        Optional plugin = this.configurablePluginManager.findById(pluginId);
        if (plugin.isPresent()) {
            this.projectManager.enablePlugin(projectId, (ConfigurablePlugin)plugin.get());
            boolean hasConfiguration = this.projectManager.pluginHasConfigurationOrSynchronisations((ConfigurablePlugin)plugin.get(), projectId);
            boolean isValid = this.configurablePluginManager.isPluginBindingValid(pluginId, projectId);
            return Collections.singletonMap("hasValidConfiguration", hasConfiguration && isValid);
        }
        throw new IllegalArgumentException("Cannot find configurable plugin with ID " + pluginId);
    }

    @RequestMapping(value={"/{projectId}/plugins/{pluginId}"}, method={RequestMethod.DELETE}, params={"saveConf"})
    @ResponseBody
    @Transactional
    public void disablePlugin(@PathVariable long projectId, @PathVariable String pluginId, @RequestParam(value="saveConf") Boolean saveConf) {
        Optional plugin = this.configurablePluginManager.findById(pluginId);
        if (!plugin.isPresent()) {
            throw new IllegalArgumentException("Cannot find configurable plugin with ID " + pluginId);
        }
        this.configurablePluginManager.disableConfigurablePlugin(pluginId, projectId, saveConf);
    }
}

