/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.importer;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;
import org.squashtest.tm.service.batchimport.excel.TemplateMismatchException;
import org.squashtest.tm.service.importer.ImportLog;
import org.squashtest.tm.web.backend.controller.importer.ImportExcelResponse;
import org.squashtest.tm.web.backend.controller.importer.ImportFormatFailure;
import org.squashtest.tm.web.backend.controller.importer.ImportHelper;

@Component
public abstract class ImportHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImportHelper.class);
    public static final String TEST_CASES = "test-cases";
    public static final String REQUIREMENT = "requirement";
    public static final String SUMMARY = "summary";

    public File multipartToImportFile(MultipartFile uploadedFile, String prefix, String suffix) throws IOException {
        InputStream is = uploadedFile.getInputStream();
        File file = File.createTempFile(prefix, suffix);
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));
        IOUtils.copy((InputStream)is, (OutputStream)os);
        IOUtils.closeQuietly((OutputStream)os);
        return file;
    }

    public ImportExcelResponse importWorkbook(String element, MultipartFile uploadedFile, Command<File, ImportLog> callback) {
        ImportExcelResponse importExcelResponse;
        ModelAndView mav;
        block10: {
            mav = new ModelAndView("fragment/import/import-summary");
            File xls = null;
            importExcelResponse = new ImportExcelResponse();
            try {
                String prefix = TEST_CASES.equals(element) ? "test-case-import-" : "requirement-import-";
                xls = this.multipartToImportFile(uploadedFile, prefix, ".xls");
                ImportLog summary = (ImportLog)callback.execute((Object)xls);
                summary.recompute();
                this.generateImportLog(element, summary);
                mav.addObject(SUMMARY, (Object)summary);
                importExcelResponse.setTemplateOk(summary);
            }
            catch (IOException e) {
                LOGGER.error("An exception prevented processing of " + element + " import file", (Throwable)e);
                if (xls != null) {
                    xls.deleteOnExit();
                }
                break block10;
            }
            catch (TemplateMismatchException tme) {
                try {
                    ImportFormatFailure importFormatFailure = new ImportFormatFailure(tme);
                    mav.addObject(SUMMARY, (Object)importFormatFailure);
                    importExcelResponse.setImportFormatFailure(importFormatFailure);
                    break block10;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (xls != null) {
                        xls.deleteOnExit();
                    }
                }
            }
            if (xls != null) {
                xls.deleteOnExit();
            }
        }
        String mavValue = TEST_CASES.equals(element) ? "test-case" : REQUIREMENT;
        mav.addObject("workspace", (Object)mavValue);
        return importExcelResponse;
    }

    private void generateImportLog(String element, ImportLog summary) {
        File xlsSummary = null;
        try {
            try {
                xlsSummary = this.importLogToLogFile(summary);
                String reportUrl = String.valueOf(element) + "/import-logs/" + xlsSummary.getName();
                summary.setReportUrl(reportUrl);
            }
            catch (IOException e) {
                LOGGER.warn("An error occurred during import log generation", (Throwable)e);
                if (xlsSummary != null) {
                    xlsSummary.deleteOnExit();
                }
            }
        }
        finally {
            if (xlsSummary != null) {
                xlsSummary.deleteOnExit();
            }
        }
    }

    protected abstract File importLogToLogFile(ImportLog var1) throws IOException;
}

