/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.form.model;

import java.util.Map;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;
import org.squashtest.tm.service.internal.dto.RawValueModel;
import org.squashtest.tm.web.backend.controller.form.model.EntityFormModel;

public class EntityFormModelValidator
implements Validator {
    private static final String MESSAGE_NOT_BLANK = "message.notBlank";

    public boolean supports(Class<?> clazz) {
        return clazz.equals(EntityFormModel.class);
    }

    public void validate(Object target, Errors errors) {
        EntityFormModel model = (EntityFormModel)target;
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"name", (String)MESSAGE_NOT_BLANK);
        if (model.getReference() != null && model.getReference().length() > 50) {
            errors.rejectValue("reference", "message.lengthMax");
        }
        for (Map.Entry entry : model.getCustomFields().entrySet()) {
            RawValueModel value = (RawValueModel)entry.getValue();
            if (!value.isEmpty()) continue;
            errors.rejectValue("customFields[" + entry.getKey() + "]", MESSAGE_NOT_BLANK);
        }
    }
}

