/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.export;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletResponse;
import org.springframework.context.MessageSource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.util.HtmlUtils;
import org.squashtest.tm.domain.requirement.ExportRequirementData;
import org.squashtest.tm.service.requirement.RequirementLibraryNavigationService;
import org.squashtest.tm.web.backend.controller.export.ExportUtil;
import org.squashtest.tm.web.backend.report.service.JasperReportsService;

@Controller
@RequestMapping(value={"/backend/requirement/export"})
public class RequirementExportController {
    private static final String JASPER_EXPORT_FILE = "WEB-INF/reports/requirement-export.jasper";
    private final MessageSource messageSource;
    private final JasperReportsService jrServices;
    private final RequirementLibraryNavigationService requirementLibraryNavigationService;

    public RequirementExportController(MessageSource messageSource, JasperReportsService jrServices, RequirementLibraryNavigationService requirementLibraryNavigationService) {
        this.messageSource = messageSource;
        this.jrServices = jrServices;
        this.requirementLibraryNavigationService = requirementLibraryNavigationService;
    }

    @RequestMapping(value={"searchExports"}, produces={"application/octet-stream"}, method={RequestMethod.GET}, params={"filename", "nodes", "add-linked-low-level-req", "keep-rte-format"})
    @ResponseBody
    public FileSystemResource searchExportAsExcel(@RequestParam(value="filename") String filename, @RequestParam(value="nodes") List<Long> nodeIds, @RequestParam(value="type") String type, @RequestParam(value="add-linked-low-level-req") Boolean addLinkedLowLevelReq, @RequestParam(value="keep-rte-format") Boolean keepRteFormat, HttpServletResponse response) throws FileNotFoundException {
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", "attachment; filename=" + filename + ".xls");
        File export = this.requirementLibraryNavigationService.searchExportRequirementAsExcel(nodeIds, keepRteFormat.booleanValue(), addLinkedLowLevelReq.booleanValue(), this.messageSource, type);
        return new FileSystemResource(export);
    }

    @RequestMapping(value={"/content/xls"}, produces={"application/octet-stream"}, method={RequestMethod.GET}, params={"filename", "libraries", "nodes", "add-linked-low-level-req", "keep-rte-format"})
    @ResponseBody
    public FileSystemResource exportAsExcel(@RequestParam(value="filename") String fileName, @RequestParam(value="libraries") List<Long> libraryIds, @RequestParam(value="nodes") List<Long> nodeIds, @RequestParam(value="add-linked-low-level-req") Boolean addLinkedLowLevelReq, @RequestParam(value="keep-rte-format") Boolean keepRtxFormat, HttpServletResponse response) {
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", "attachment; filename=" + fileName + ".xls");
        File export = this.requirementLibraryNavigationService.exportRequirementAsExcel(libraryIds, nodeIds, addLinkedLowLevelReq.booleanValue(), keepRtxFormat.booleanValue(), this.messageSource);
        return new FileSystemResource(export);
    }

    @Deprecated
    @RequestMapping(value={"/content/csv"}, produces={"application/octet-stream"}, method={RequestMethod.GET}, params={"filename", "libraries", "nodes", "keep-rte-format", "isCurrentVersion"})
    @ResponseBody
    public void exportAsCsv(@RequestParam(value="filename") String filename, @RequestParam(value="libraries") List<Long> libraryIds, @RequestParam(value="nodes") List<Long> nodeIds, @RequestParam(value="keep-rte-format") Boolean keepRteFormat, @RequestParam(value="isCurrentVersion") Boolean isCurrentVersion, Locale locale, HttpServletResponse response) {
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", "attachment; filename=" + filename + ".xls");
        ArrayList dataSource = new ArrayList();
        if (!libraryIds.isEmpty()) {
            dataSource.addAll(this.requirementLibraryNavigationService.findRequirementsToExportFromLibrary(libraryIds));
        }
        if (!nodeIds.isEmpty()) {
            dataSource.addAll(this.requirementLibraryNavigationService.findRequirementsToExportFromNodes(nodeIds));
        }
        this.convertHtmlSpecialCharactersToUnicode(dataSource);
        this.printExport(dataSource, filename, response, locale, keepRteFormat);
    }

    private void printExport(List<ExportRequirementData> dataSource, String filename, HttpServletResponse response, Locale locale, Boolean keepRteFormat) {
        ExportUtil.printExport(dataSource, (String)filename, (String)JASPER_EXPORT_FILE, (HttpServletResponse)response, (Locale)locale, (String)"csv", (boolean)keepRteFormat, new HashMap(), (MessageSource)this.messageSource, (JasperReportsService)this.jrServices);
    }

    private void convertHtmlSpecialCharactersToUnicode(List<ExportRequirementData> dataSource) {
        for (ExportRequirementData data : dataSource) {
            data.setDescription(HtmlUtils.htmlUnescape((String)data.getDescription()));
        }
    }
}

