/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.connection.logs;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.service.display.connection.log.ConnectionLogDisplayService;
import org.squashtest.tm.service.internal.display.grid.GridFilterValue;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.grid.GridResponse;
import org.squashtest.tm.service.internal.display.grid.GridSort;
import org.squashtest.tm.web.backend.controller.connection.logs.ConnectionLogsController;

/*
 * Exception performing whole class analysis ignored.
 */
@Controller
@RequestMapping(value={"/backend/users/connection-logs"})
public class ConnectionLogsController {
    private final ConnectionLogDisplayService connectionLogDisplayService;

    ConnectionLogsController(ConnectionLogDisplayService connectionLogDisplayService) {
        this.connectionLogDisplayService = connectionLogDisplayService;
    }

    @PostMapping
    @ResponseBody
    public GridResponse getAllConnectionLogs(@RequestBody GridRequest request) {
        return this.connectionLogDisplayService.findAll(request);
    }

    @PostMapping(value={"/export"})
    @ResponseBody
    public Map<String, String> exportConnectionLog(@RequestBody ExportRequestBody requestBody) {
        GridRequest gridRequest = this.prepareNonPaginatedGridRequest(requestBody.getFilterValues());
        GridResponse gridResponse = this.connectionLogDisplayService.findAll(gridRequest);
        String export = ExportFileBuilder.exportAsCSV((GridResponse)gridResponse);
        return Collections.singletonMap("export", export);
    }

    private GridRequest prepareNonPaginatedGridRequest(List<GridFilterValue> filterValues) {
        GridRequest gridRequest = new GridRequest();
        gridRequest.setFilterValues(filterValues);
        GridSort gridSort = new GridSort("connectionDate", GridSort.SortDirection.ASC);
        gridRequest.setSort(Collections.singletonList(gridSort));
        return gridRequest.toNonPaginatedRequest();
    }
}

