/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.campaign;

import java.util.Collections;
import java.util.Locale;
import javax.inject.Named;
import javax.inject.Provider;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.Workspace;
import org.squashtest.tm.domain.customreport.CustomReportDashboard;
import org.squashtest.tm.service.campaign.IterationModificationService;
import org.squashtest.tm.service.customreport.CustomReportLibraryNodeService;
import org.squashtest.tm.service.display.campaign.IterationDisplayService;
import org.squashtest.tm.service.internal.display.dto.campaign.IterationDto;
import org.squashtest.tm.service.internal.dto.json.JsonCustomReportDashboard;
import org.squashtest.tm.service.statistics.iteration.IterationStatisticsBundle;
import org.squashtest.tm.web.backend.model.builder.JsonCustomReportDashboardBuilder;

@RestController
@RequestMapping(value={"backend/iteration-view"})
public class IterationViewController {
    private final IterationDisplayService iterationDisplayService;
    private final IterationModificationService iterationModificationService;
    private final CustomReportLibraryNodeService customReportLibraryNodeService;
    @Named(value="customReport.dashboardBuilder")
    private final Provider<JsonCustomReportDashboardBuilder> builderProvider;

    public IterationViewController(IterationDisplayService iterationDisplayService, IterationModificationService iterationModificationService, CustomReportLibraryNodeService customReportLibraryNodeService, Provider<JsonCustomReportDashboardBuilder> builderProvider) {
        this.iterationDisplayService = iterationDisplayService;
        this.iterationModificationService = iterationModificationService;
        this.customReportLibraryNodeService = customReportLibraryNodeService;
        this.builderProvider = builderProvider;
    }

    @RequestMapping(value={"/{iterationId}"}, method={RequestMethod.GET})
    public IterationDto getIterationView(@PathVariable Long iterationId, Locale locale) {
        IterationDto dto = this.iterationDisplayService.findIterationView(iterationId);
        if (dto.isShouldShowFavoriteDashboard() && dto.isCanShowFavoriteDashboard()) {
            EntityReference library = new EntityReference(EntityType.ITERATION, iterationId);
            CustomReportDashboard dashboard = this.customReportLibraryNodeService.findCustomReportDashboardById(dto.getFavoriteDashboardId());
            JsonCustomReportDashboard jsonDashboard = ((JsonCustomReportDashboardBuilder)this.builderProvider.get()).build(dto.getFavoriteDashboardId(), dashboard, locale, Collections.singletonList(library), false, Workspace.CAMPAIGN);
            dto.setDashboard(jsonDashboard);
        }
        return dto;
    }

    @RequestMapping(value={"/{iterationId}/statistics"}, method={RequestMethod.GET})
    public IterationStatisticsBundle getIterationStatistics(@PathVariable long iterationId) {
        return this.iterationModificationService.gatherIterationStatisticsBundle(iterationId);
    }
}

