/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.campaign;

import java.util.Date;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.IterationStatus;
import org.squashtest.tm.service.campaign.IterationModificationService;
import org.squashtest.tm.web.backend.controller.campaign.IterationModificationController;

@RestController
@RequestMapping(value={"backend/iteration/{iterationId}"})
public class IterationModificationController {
    private final IterationModificationService iterationModificationService;

    public IterationModificationController(IterationModificationService iterationModificationService) {
        this.iterationModificationService = iterationModificationService;
    }

    @ResponseBody
    @PostMapping(value={"/name"})
    public void rename(@PathVariable Long iterationId, @RequestBody IterationPatch patch) {
        this.iterationModificationService.rename(iterationId.longValue(), patch.getName());
    }

    @ResponseBody
    @PostMapping(value={"/reference"})
    public void changeReference(@PathVariable Long iterationId, @RequestBody IterationPatch patch) {
        this.iterationModificationService.changeReference(iterationId.longValue(), patch.getReference());
    }

    @ResponseBody
    @PostMapping(value={"/description"})
    public void changeDescription(@PathVariable Long iterationId, @RequestBody IterationPatch patch) {
        this.iterationModificationService.changeDescription(iterationId.longValue(), patch.getDescription());
    }

    @ResponseBody
    @PostMapping(value={"/iteration-status"})
    public void changeCampaignStatus(@PathVariable Long iterationId, @RequestBody IterationPatch patch) {
        this.iterationModificationService.changeStatus(iterationId.longValue(), IterationStatus.valueOf((String)patch.getIterationStatus()));
    }

    @ResponseBody
    @PostMapping(value={"/scheduled-start-date"})
    public void setScheduledStart(@PathVariable long iterationId, @RequestBody IterationPatch patch) {
        this.iterationModificationService.changeScheduledStartDate(iterationId, patch.getScheduledStartDate());
    }

    @PostMapping(value={"/scheduled-end-date"})
    @ResponseBody
    public void setScheduledEnd(@PathVariable long iterationId, @RequestBody IterationPatch patch) {
        this.iterationModificationService.changeScheduledEndDate(iterationId, patch.getScheduledEndDate());
    }

    @PostMapping(value={"/actual-start-date"})
    @ResponseBody
    public void setActualStart(@PathVariable long iterationId, @RequestBody IterationPatch patch) {
        this.iterationModificationService.changeActualStartDate(iterationId, patch.getActualStartDate());
    }

    @PostMapping(value={"/actual-end-date"})
    @ResponseBody
    public void setActualEnd(@PathVariable long iterationId, @RequestBody IterationPatch patch) {
        this.iterationModificationService.changeActualEndDate(iterationId, patch.getActualEndDate());
    }

    @PostMapping(value={"/actual-start-auto"})
    @ResponseBody
    public Date setActualStartAuto(@PathVariable long iterationId, @RequestBody IterationPatch patch) {
        this.iterationModificationService.changeActualStartAuto(iterationId, patch.getActualStartAuto().booleanValue());
        Iteration iteration = (Iteration)this.iterationModificationService.findById(iterationId);
        return iteration.getActualStartDate();
    }

    @PostMapping(value={"/actual-end-auto"})
    @ResponseBody
    public Date setActualEndAuto(@PathVariable long iterationId, @RequestBody IterationPatch patch) {
        this.iterationModificationService.changeActualEndAuto(iterationId, patch.getActualEndAuto().booleanValue());
        Iteration iteration = (Iteration)this.iterationModificationService.findById(iterationId);
        return iteration.getActualEndDate();
    }
}

