/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.campaign;

import java.util.Collections;
import java.util.Locale;
import javax.inject.Named;
import javax.inject.Provider;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.Workspace;
import org.squashtest.tm.domain.customreport.CustomReportDashboard;
import org.squashtest.tm.service.campaign.CampaignModificationService;
import org.squashtest.tm.service.customreport.CustomReportLibraryNodeService;
import org.squashtest.tm.service.display.campaign.CampaignDisplayService;
import org.squashtest.tm.service.internal.display.dto.campaign.CampaignFolderDto;
import org.squashtest.tm.service.internal.dto.json.JsonCustomReportDashboard;
import org.squashtest.tm.service.statistics.campaign.ManyCampaignStatisticsBundle;
import org.squashtest.tm.web.backend.model.builder.JsonCustomReportDashboardBuilder;

@RestController
@RequestMapping(value={"/backend/campaign-folder-view"})
public class CampaignFolderViewController {
    private CampaignDisplayService campaignDisplayService;
    private final CustomReportLibraryNodeService customReportLibraryNodeService;
    @Named(value="customReport.dashboardBuilder")
    private final Provider<JsonCustomReportDashboardBuilder> builderProvider;
    private CampaignModificationService campaignModificationService;

    public CampaignFolderViewController(CampaignDisplayService campaignDisplayService, CampaignModificationService campaignModificationService, CustomReportLibraryNodeService customReportLibraryNodeService, Provider<JsonCustomReportDashboardBuilder> builderProvider) {
        this.campaignDisplayService = campaignDisplayService;
        this.customReportLibraryNodeService = customReportLibraryNodeService;
        this.builderProvider = builderProvider;
        this.campaignModificationService = campaignModificationService;
    }

    @RequestMapping(value={"/{campaignFolderId}"}, method={RequestMethod.GET})
    public CampaignFolderDto getCampaignFolderView(@PathVariable long campaignFolderId, Locale locale) {
        CampaignFolderDto dto = this.campaignDisplayService.getCampaignFolderView(campaignFolderId);
        if (dto.isShouldShowFavoriteDashboard() && dto.isCanShowFavoriteDashboard()) {
            EntityReference library = new EntityReference(EntityType.CAMPAIGN_FOLDER, Long.valueOf(campaignFolderId));
            CustomReportDashboard dashboard = this.customReportLibraryNodeService.findCustomReportDashboardById(dto.getFavoriteDashboardId());
            JsonCustomReportDashboard jsonDashboard = ((JsonCustomReportDashboardBuilder)this.builderProvider.get()).build(dto.getFavoriteDashboardId(), dashboard, locale, Collections.singletonList(library), false, Workspace.CAMPAIGN);
            dto.setDashboard(jsonDashboard);
        }
        return dto;
    }

    @RequestMapping(value={"/{campaignFolderId}/statistics"}, method={RequestMethod.GET})
    public ManyCampaignStatisticsBundle getCampaignFolderStatistics(@PathVariable long campaignFolderId) {
        return this.campaignModificationService.gatherFolderStatisticsBundle(Long.valueOf(campaignFolderId));
    }
}

