/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.bugtracker;

import java.beans.PropertyEditor;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.csp.core.bugtracker.core.BugTrackerManagerException;
import org.squashtest.csp.core.bugtracker.domain.BTIssue;
import org.squashtest.csp.core.bugtracker.domain.BugTracker;
import org.squashtest.csp.core.bugtracker.spi.BugTrackerInterfaceDescriptor;
import org.squashtest.tm.bugtracker.advanceddomain.AdvancedIssue;
import org.squashtest.tm.bugtracker.advanceddomain.DelegateCommand;
import org.squashtest.tm.bugtracker.advanceddomain.RemoteIssueSearchForm;
import org.squashtest.tm.bugtracker.definition.Attachment;
import org.squashtest.tm.bugtracker.definition.RemoteIssue;
import org.squashtest.tm.bugtracker.definition.context.BugTrackerBindingInfo;
import org.squashtest.tm.bugtracker.definition.context.RemoteIssueContext;
import org.squashtest.tm.core.foundation.collection.PagingAndSorting;
import org.squashtest.tm.domain.bugtracker.IssueDetector;
import org.squashtest.tm.domain.campaign.Campaign;
import org.squashtest.tm.domain.campaign.CampaignFolder;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.execution.ExecutionStep;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.domain.servers.AuthenticationStatus;
import org.squashtest.tm.domain.servers.Credentials;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.users.PartyPreference;
import org.squashtest.tm.domain.users.preferences.CorePartyPreference;
import org.squashtest.tm.exception.bugtracker.BugTrackerManagerActionException;
import org.squashtest.tm.service.bugtracker.BugTrackerManagerService;
import org.squashtest.tm.service.bugtracker.BugTrackersLocalService;
import org.squashtest.tm.service.bugtracker.BugTrackersService;
import org.squashtest.tm.service.bugtracker.knownissues.remote.RemoteKnownIssueFinder;
import org.squashtest.tm.service.campaign.CampaignFinder;
import org.squashtest.tm.service.campaign.CampaignLibraryNavigationService;
import org.squashtest.tm.service.campaign.IterationFinder;
import org.squashtest.tm.service.campaign.TestSuiteFinder;
import org.squashtest.tm.service.execution.ExecutionFinder;
import org.squashtest.tm.service.internal.bugtracker.BugTrackerConnectorFactory;
import org.squashtest.tm.service.internal.bugtracker.RemoteIssueContextHelper;
import org.squashtest.tm.service.internal.bugtracker.knownissues.remote.KnownIssuesGridResponseBuilder;
import org.squashtest.tm.service.internal.configuration.CallbackUrlProvider;
import org.squashtest.tm.service.internal.display.dto.IssuesPanelModel;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.grid.GridResponse;
import org.squashtest.tm.service.internal.utils.HTMLCleanupUtils;
import org.squashtest.tm.service.project.GenericProjectManagerService;
import org.squashtest.tm.service.requirement.RequirementVersionManagerService;
import org.squashtest.tm.service.testautomation.spi.BadConfiguration;
import org.squashtest.tm.service.testcase.TestCaseFinder;
import org.squashtest.tm.service.user.PartyPreferenceService;
import org.squashtest.tm.web.backend.controller.attachment.UploadedData;
import org.squashtest.tm.web.backend.controller.attachment.UploadedDataPropertyEditorSupport;
import org.squashtest.tm.web.backend.controller.bugtracker.BugTrackerControllerHelper;
import org.squashtest.tm.web.backend.controller.bugtracker.RemoteIssuesController;
import org.squashtest.tm.web.backend.helper.JsonHelper;
import org.squashtest.tm.web.i18n.InternationalizationHelper;
import oslcdomain.OslcIssue;

@Controller
@RequestMapping(value={"/backend/issues"})
public class RemoteIssuesController {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteIssuesController.class);
    private final BugTrackerConnectorFactory btFactory;
    private final BugTrackersLocalService bugTrackersLocalService;
    private final BugTrackersService bugTrackersService;
    private final RequirementVersionManagerService requirementVersionManager;
    private final CampaignFinder campaignFinder;
    private final IterationFinder iterationFinder;
    private final TestSuiteFinder testSuiteFinder;
    private final ExecutionFinder executionFinder;
    private final BugTrackerManagerService bugTrackerManagerService;
    private final InternationalizationHelper messageSource;
    private final CampaignLibraryNavigationService clnService;
    private final TestCaseFinder testCaseFinder;
    private final PartyPreferenceService partyPreferenceService;
    private final GenericProjectManagerService projectManager;
    private final CallbackUrlProvider callbackUrlProvider;
    private final RemoteKnownIssueFinder remoteKnownIssueFinder;
    private final KnownIssuesGridResponseBuilder knownIssuesGridResponseBuilder;
    static final String EXECUTION_STEP_TYPE = "execution-step";
    static final String EXECUTION_TYPE = "execution";
    static final String ITERATION_TYPE = "iteration";
    static final String CAMPAIGN_TYPE = "campaign";
    static final String TEST_SUITE_TYPE = "test-suite";
    static final String TEST_CASE_TYPE = "test-case";
    static final String CAMPAIGN_FOLDER_TYPE = "campaign-folder";
    static final String REQUIREMENT_VERSION_TYPE = "requirement-version";
    private static final String POSTING_NEW_ISSUE_MESSAGE = "BugTrackerController: posting a new issue for execution-step ";

    RemoteIssuesController(BugTrackerConnectorFactory btFactory, BugTrackersLocalService bugTrackersLocalService, RequirementVersionManagerService requirementVersionManager, CampaignFinder campaignFinder, IterationFinder iterationFinder, TestSuiteFinder testSuiteFinder, ExecutionFinder executionFinder, BugTrackerManagerService bugTrackerManagerService, InternationalizationHelper messageSource, CampaignLibraryNavigationService clnService, TestCaseFinder testCaseFinder, BugTrackersService bugTrackersService, PartyPreferenceService partyPreferenceService, GenericProjectManagerService projectManager, CallbackUrlProvider callbackUrlProvider, RemoteKnownIssueFinder remoteKnownIssueFinder, KnownIssuesGridResponseBuilder knownIssuesGridResponseBuilder) {
        this.btFactory = btFactory;
        this.bugTrackersLocalService = bugTrackersLocalService;
        this.requirementVersionManager = requirementVersionManager;
        this.campaignFinder = campaignFinder;
        this.iterationFinder = iterationFinder;
        this.testSuiteFinder = testSuiteFinder;
        this.executionFinder = executionFinder;
        this.bugTrackerManagerService = bugTrackerManagerService;
        this.messageSource = messageSource;
        this.clnService = clnService;
        this.testCaseFinder = testCaseFinder;
        this.bugTrackersService = bugTrackersService;
        this.partyPreferenceService = partyPreferenceService;
        this.projectManager = projectManager;
        this.callbackUrlProvider = callbackUrlProvider;
        this.remoteKnownIssueFinder = remoteKnownIssueFinder;
        this.knownIssuesGridResponseBuilder = knownIssuesGridResponseBuilder;
    }

    @InitBinder
    public void initBinder(ServletRequestDataBinder binder) throws ServletException {
        binder.registerCustomEditor(UploadedData.class, (PropertyEditor)new UploadedDataPropertyEditorSupport());
    }

    @RequestMapping(value={"projects/{projectId}/bugtracker"}, method={RequestMethod.GET})
    @ResponseBody
    BugTrackerInfo getBugtrackerInfo(@PathVariable long projectId) {
        GenericProject project = this.projectManager.findById(projectId);
        BugTrackerInfo response = new BugTrackerInfo();
        if (project.isBugtrackerConnected()) {
            response.setProjectNames(project.getBugtrackerBinding().getProjectNames());
            response.setKind(project.getBugtrackerBinding().getBugtracker().getKind());
        }
        return response;
    }

    @GetMapping(value={"execution-step/{stepId}"})
    @ResponseBody
    public IssuesPanelModel getExecStepIssuePanel(@PathVariable Long stepId, Locale locale) {
        ExecutionStep step = this.executionFinder.findExecutionStepById(stepId.longValue());
        return this.makeIssuePanel(EXECUTION_STEP_TYPE, locale, step.getProject());
    }

    @PostMapping(value={"execution-step/{stepId}/known-issues"})
    @ResponseBody
    public GridResponse getExecStepKnownIssuesData(@PathVariable Long stepId, @RequestBody GridRequest gridRequest) {
        IssueDisplaySorting sorter = new IssueDisplaySorting(gridRequest);
        List knownIssues = this.remoteKnownIssueFinder.findForExecutionStep(stepId.longValue(), (PagingAndSorting)sorter);
        int totalCount = this.remoteKnownIssueFinder.getCountForExecutionStep(stepId);
        return this.knownIssuesGridResponseBuilder.asKnownIssuesGridResponse(knownIssues, totalCount);
    }

    @GetMapping(value={"execution-step/{stepId}/new-issue"})
    @ResponseBody
    public RemoteIssue getExecStepReportStub(@PathVariable Long stepId, HttpServletRequest request, @RequestParam(value="project-name") String projectName) {
        ExecutionStep step = this.executionFinder.findExecutionStepById(stepId.longValue());
        String baseUrl = this.getSquashPublicUrl(request);
        return this.makeExecutionStepReportIssueModel(step, projectName, baseUrl);
    }

    @PostMapping(value={"execution-step/{stepId}/new-issue"})
    @ResponseBody
    public Map<String, String> postExecStepIssueReport(@PathVariable Long stepId, @RequestBody BTIssue jsonIssue) {
        LOGGER.trace(POSTING_NEW_ISSUE_MESSAGE + stepId);
        ExecutionStep entity = this.executionFinder.findExecutionStepById(stepId.longValue());
        if (jsonIssue.hasBlankId()) {
            return this.processIssue((RemoteIssue)jsonIssue, (IssueDetector)entity);
        }
        return this.attachIssue((RemoteIssue)jsonIssue, (IssueDetector)entity);
    }

    @PostMapping(value={"execution-step/{stepId}/new-advanced-issue"})
    @ResponseBody
    public Map<String, String> postExecStepAdvancedIssueReport(@PathVariable Long stepId, @RequestBody AdvancedIssue jsonIssue) {
        LOGGER.trace(POSTING_NEW_ISSUE_MESSAGE + stepId);
        ExecutionStep entity = this.executionFinder.findExecutionStepById(stepId.longValue());
        if (jsonIssue.hasBlankId()) {
            return this.processIssue((RemoteIssue)jsonIssue, (IssueDetector)entity);
        }
        return this.attachIssue((RemoteIssue)jsonIssue, (IssueDetector)entity);
    }

    @PostMapping(value={"execution-step/{stepId}/new-oslc-issue"})
    @ResponseBody
    public void postExecStepIssueReport(@PathVariable Long stepId, @RequestBody NewOslcIssueRequestBody requestBody) {
        LOGGER.trace(POSTING_NEW_ISSUE_MESSAGE + stepId);
        ExecutionStep entity = this.executionFinder.findExecutionStepById(stepId.longValue());
        OslcIssue issue = new OslcIssue();
        issue.setId(requestBody.getIssueId());
        this.attachIssue((RemoteIssue)issue, (IssueDetector)entity);
    }

    @GetMapping(value={"execution/{execId}"})
    @ResponseBody
    public IssuesPanelModel getExecIssuePanel(@PathVariable Long execId, Locale locale) {
        Execution execution = this.executionFinder.findById(execId.longValue());
        return this.makeIssuePanel(EXECUTION_TYPE, locale, execution.getProject());
    }

    @PostMapping(value={"execution/{execId}/known-issues"})
    @ResponseBody
    public GridResponse getExecKnownIssuesData(@PathVariable Long execId, @RequestBody GridRequest gridRequest) {
        IssueDisplaySorting sorter = new IssueDisplaySorting(gridRequest);
        List knownIssues = this.remoteKnownIssueFinder.findForExecution(execId.longValue(), (PagingAndSorting)sorter);
        int totalCount = this.remoteKnownIssueFinder.getCountForExecution(execId);
        return this.knownIssuesGridResponseBuilder.asKnownIssuesGridResponse(knownIssues, totalCount);
    }

    @PostMapping(value={"execution/{execId}/all-known-issues"})
    @ResponseBody
    public GridResponse getExecKnownIssuesDataWithoutPaging(@PathVariable Long execId) {
        List knownIssues = this.remoteKnownIssueFinder.findUngroupedForExecution(execId);
        int totalCount = this.remoteKnownIssueFinder.getCountForExecution(execId);
        return this.knownIssuesGridResponseBuilder.asKnownIssuesGridResponse(knownIssues, totalCount);
    }

    @GetMapping(value={"execution/{execId}/new-issue"})
    @ResponseBody
    public RemoteIssue getExecReportStub(@PathVariable Long execId, Locale locale, HttpServletRequest request, @RequestParam(value="project-name") String projectName) {
        Execution execution = this.executionFinder.findById(execId.longValue());
        String baseUrl = this.getSquashPublicUrl(request);
        return this.makeExecutionReportIssueModel(execution, projectName, baseUrl);
    }

    private String getSquashPublicUrl(HttpServletRequest request) {
        try {
            return this.callbackUrlProvider.getCallbackUrl().toExternalForm();
        }
        catch (BadConfiguration badConfiguration) {
            return BugTrackerControllerHelper.extractBaseUrl((HttpServletRequest)request);
        }
    }

    @PostMapping(value={"execution/{execId}/new-issue"})
    @ResponseBody
    public Object postExecIssueReport(@PathVariable Long execId, @RequestBody BTIssue jsonIssue) {
        LOGGER.trace(POSTING_NEW_ISSUE_MESSAGE + execId);
        Execution entity = this.executionFinder.findById(execId.longValue());
        if (jsonIssue.hasBlankId()) {
            return this.processIssue((RemoteIssue)jsonIssue, (IssueDetector)entity);
        }
        return this.attachIssue((RemoteIssue)jsonIssue, (IssueDetector)entity);
    }

    @PostMapping(value={"execution/{execId}/new-advanced-issue"})
    @ResponseBody
    public Object postExecAdvancedIssueReport(@PathVariable Long execId, @RequestBody AdvancedIssue jsonIssue) {
        LOGGER.trace(POSTING_NEW_ISSUE_MESSAGE + execId);
        Execution entity = this.executionFinder.findById(execId.longValue());
        if (jsonIssue.hasBlankId()) {
            return this.processIssue((RemoteIssue)jsonIssue, (IssueDetector)entity);
        }
        return this.attachIssue((RemoteIssue)jsonIssue, (IssueDetector)entity);
    }

    @PostMapping(value={"execution/{execId}/new-oslc-issue"})
    @ResponseBody
    public void postExecIssueReport(@PathVariable Long execId, @RequestBody NewOslcIssueRequestBody requestBody) {
        LOGGER.trace("BugTrackerController: posting a new issue for execution " + execId);
        Execution entity = this.executionFinder.findById(execId.longValue());
        OslcIssue issue = new OslcIssue();
        issue.setId(requestBody.getIssueId());
        this.attachIssue((RemoteIssue)issue, (IssueDetector)entity);
    }

    @GetMapping(value={"requirement-version/{rvId}"})
    @ResponseBody
    public IssuesPanelModel getRequirementWorkspaceIssuePanel(@PathVariable Long rvId, Locale locale) {
        RequirementVersion requirementVersion = this.requirementVersionManager.findById(rvId.longValue());
        return this.makeIssuePanel(REQUIREMENT_VERSION_TYPE, locale, requirementVersion.getProject());
    }

    @PostMapping(value={"requirement-version/{rvId}/known-issues/all"})
    @ResponseBody
    public GridResponse getRequirementVersionKnownIssuesData(@PathVariable Long rvId, @RequestBody GridRequest gridRequest) {
        IssueDisplaySorting sorter = new IssueDisplaySorting(gridRequest);
        List knownIssues = this.remoteKnownIssueFinder.findForRequirementVersion(rvId.longValue(), (PagingAndSorting)sorter);
        int totalCount = this.remoteKnownIssueFinder.getCountForRequirementVersion(rvId);
        return this.knownIssuesGridResponseBuilder.asKnownIssuesGridResponse(knownIssues, totalCount);
    }

    @GetMapping(value={"test-case/{tcId}"})
    @ResponseBody
    public IssuesPanelModel getTestCaseIssuePanel(@PathVariable Long tcId, Locale locale) {
        TestCase testCase = this.testCaseFinder.findById(tcId.longValue());
        return this.makeIssuePanel(TEST_CASE_TYPE, locale, testCase.getProject());
    }

    @PostMapping(value={"test-case/{tcId}/known-issues"})
    @ResponseBody
    public GridResponse getTestCaseKnownIssuesData(@PathVariable Long tcId, @RequestBody GridRequest gridRequest) {
        IssueDisplaySorting sorter = new IssueDisplaySorting(gridRequest);
        List knownIssues = this.remoteKnownIssueFinder.findForTestCase(tcId.longValue(), (PagingAndSorting)sorter);
        int totalCount = this.remoteKnownIssueFinder.getCountForTestCase(tcId);
        return this.knownIssuesGridResponseBuilder.asKnownIssuesGridResponse(knownIssues, totalCount);
    }

    @GetMapping(value={"iteration/{iterId}"})
    @ResponseBody
    public IssuesPanelModel getIterationIssuePanel(@PathVariable Long iterId, Locale locale) {
        Iteration iteration = (Iteration)this.iterationFinder.findById(iterId.longValue());
        return this.makeIssuePanel(ITERATION_TYPE, locale, iteration.getProject());
    }

    @PostMapping(value={"iteration/{iterId}/known-issues"})
    @ResponseBody
    public GridResponse getIterationKnownIssuesData(@PathVariable Long iterId, @RequestBody GridRequest gridRequest) {
        IssueDisplaySorting sorter = new IssueDisplaySorting(gridRequest);
        List knownIssues = this.remoteKnownIssueFinder.findForIteration(iterId.longValue(), (PagingAndSorting)sorter);
        int totalCount = this.remoteKnownIssueFinder.getCountForIteration(iterId);
        return this.knownIssuesGridResponseBuilder.asKnownIssuesGridResponse(knownIssues, totalCount);
    }

    @GetMapping(value={"campaign/{campId}"})
    @ResponseBody
    public IssuesPanelModel getCampaignIssuePanel(@PathVariable Long campId, Locale locale) {
        Campaign campaign = this.campaignFinder.findById(campId.longValue());
        return this.makeIssuePanel(CAMPAIGN_TYPE, locale, campaign.getProject());
    }

    @PostMapping(value={"campaign/{campId}/known-issues"})
    @ResponseBody
    public GridResponse getCampaignKnownIssuesData(@PathVariable Long campId, @RequestBody GridRequest gridRequest) {
        IssueDisplaySorting sorter = new IssueDisplaySorting(gridRequest);
        List knownIssues = this.remoteKnownIssueFinder.findForCampaign(campId.longValue(), (PagingAndSorting)sorter);
        int totalCount = this.remoteKnownIssueFinder.getCountForCampaign(campId);
        return this.knownIssuesGridResponseBuilder.asKnownIssuesGridResponse(knownIssues, totalCount);
    }

    @GetMapping(value={"test-suite/{testSuiteId}"})
    @ResponseBody
    public IssuesPanelModel getTestSuiteIssuePanel(@PathVariable Long testSuiteId, Locale locale) {
        TestSuite testSuite = (TestSuite)this.testSuiteFinder.findById(testSuiteId.longValue());
        return this.makeIssuePanel(TEST_SUITE_TYPE, locale, testSuite.getProject());
    }

    @PostMapping(value={"test-suite/{testSuiteId}/known-issues"})
    @ResponseBody
    public GridResponse getTestSuiteKnownIssuesData(@PathVariable Long testSuiteId, @RequestBody GridRequest gridRequest) {
        IssueDisplaySorting sorter = new IssueDisplaySorting(gridRequest);
        List knownIssues = this.remoteKnownIssueFinder.findForTestSuite(testSuiteId.longValue(), (PagingAndSorting)sorter);
        int totalCount = this.remoteKnownIssueFinder.getCountForTestSuite(testSuiteId);
        return this.knownIssuesGridResponseBuilder.asKnownIssuesGridResponse(knownIssues, totalCount);
    }

    @GetMapping(value={"campaign-folder/{campaignFolderId}"})
    @ResponseBody
    public IssuesPanelModel getCampaignFolderIssuePanel(@PathVariable Long campaignFolderId, Locale locale) {
        CampaignFolder campaignFolder = (CampaignFolder)this.clnService.findFolder(campaignFolderId.longValue());
        return this.makeIssuePanel(CAMPAIGN_FOLDER_TYPE, locale, campaignFolder.getProject());
    }

    @PostMapping(value={"campaign-folder/{campaignFolderId}/known-issues"})
    @ResponseBody
    public GridResponse getCampaignFolderKnownIssuesData(@PathVariable Long campaignFolderId, @RequestBody GridRequest gridRequest) {
        IssueDisplaySorting sorter = new IssueDisplaySorting(gridRequest);
        List knownIssues = this.remoteKnownIssueFinder.findForCampaignFolder(campaignFolderId.longValue(), (PagingAndSorting)sorter);
        int totalCount = this.remoteKnownIssueFinder.getCountForCampaignFolder(campaignFolderId);
        return this.knownIssuesGridResponseBuilder.asKnownIssuesGridResponse(knownIssues, totalCount);
    }

    @PostMapping(value={"/issue-search-form"})
    @ResponseBody
    public RemoteIssueSearchForm getIssueSearchForm(@RequestBody GetIssueSearchFormRequestBody requestBody) {
        BugTracker bugTracker = this.bugTrackerManagerService.findById(requestBody.bugTrackerId.longValue());
        GenericProject project = this.projectManager.findById(requestBody.projectId.longValue());
        BugTrackerBindingInfo bugTrackerBindingInfo = this.bugTrackersService.getBugTrackerBindingInfo(project);
        return this.bugTrackersService.getRemoteIssueSearchForm(bugTracker, bugTrackerBindingInfo);
    }

    @PostMapping(value={"/search-issue"})
    @ResponseBody
    public RemoteIssue findIssue(@RequestBody FindIssueRequestBody requestBody) {
        BugTracker bugTracker = this.bugTrackerManagerService.findById(requestBody.bugTrackerId.longValue());
        return this.bugTrackersLocalService.searchIssue(requestBody.toSearchRequest(), bugTracker).orElse(null);
    }

    private Map<String, String> processIssue(RemoteIssue issue, IssueDetector entity) {
        RemoteIssue postedIssue = this.bugTrackersLocalService.createIssue(entity, issue);
        URL issueUrl = this.bugTrackersLocalService.getIssueUrl(postedIssue.getId(), entity.getBugTracker());
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("url", issueUrl.toString());
        result.put("issueId", postedIssue.getId());
        List remoteReqIds = this.bugTrackersLocalService.findAllRemoteReqIdByServerUrlVerifiedByATestCase(entity.getBugTracker().getUrl(), entity.getReferencedTestCase().getId());
        if (!remoteReqIds.isEmpty()) {
            this.bugTrackersLocalService.linkIssueToRemoteRequirements(postedIssue.getId(), remoteReqIds, entity.getBugTracker());
        }
        return result;
    }

    private Map<String, String> attachIssue(RemoteIssue issue, IssueDetector entity) {
        this.bugTrackersLocalService.attachIssue(issue, entity, issue.getId());
        URL issueUrl = this.bugTrackersLocalService.getIssueUrl(issue.getId(), entity.getBugTracker());
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("url", issueUrl.toString());
        result.put("issueId", issue.getId());
        List remoteReqIds = this.bugTrackersLocalService.findAllRemoteReqIdByServerUrlVerifiedByATestCase(entity.getBugTracker().getUrl(), entity.getReferencedTestCase().getId());
        if (!remoteReqIds.isEmpty()) {
            this.bugTrackersLocalService.linkIssueToRemoteRequirements(issue.getId(), remoteReqIds, entity.getBugTracker());
        }
        return result;
    }

    @DeleteMapping(value={"/{issueIds}"})
    @ResponseBody
    public void detachIssues(@PathVariable List<Long> issueIds) {
        this.bugTrackersLocalService.detachIssues(issueIds);
    }

    @PostMapping(value={"/{btName}/{remoteIssueId}/attachments"})
    @ResponseBody
    public void forwardAttachmentsToIssue(@PathVariable String btName, @PathVariable String remoteIssueId, @RequestParam(value="attachment[]") List<UploadedData> uploads) {
        ArrayList<Attachment> issueAttachments = new ArrayList<Attachment>(uploads.size());
        for (UploadedData upload : uploads) {
            Attachment newAttachment = new Attachment(upload.getName(), upload.getSizeInBytes(), upload.getStream());
            issueAttachments.add(newAttachment);
        }
        this.bugTrackersLocalService.forwardAttachments(remoteIssueId, btName, issueAttachments);
        for (Attachment attachment : issueAttachments) {
            try {
                attachment.getStreamContent().close();
            }
            catch (IOException ex) {
                LOGGER.warn("issue attachments : could not close stream for " + attachment.getName() + ", this is non fatal anyway", (Throwable)ex);
            }
        }
    }

    @PostMapping(value={"{bugtrackerName}/command"})
    @ResponseBody
    public Object forwardDelegateCommand(@PathVariable String bugtrackerName, @RequestBody DelegateCommand command) {
        return this.bugTrackersLocalService.forwardDelegateCommand(command, bugtrackerName);
    }

    private RemoteIssue makeExecutionReportIssueModel(Execution exec, String projectName, String squashPublicUrl) {
        RemoteIssueContext context = RemoteIssueContextHelper.getRemoteIssueContext((Execution)exec, (String)squashPublicUrl, (MessageSource)this.messageSource);
        RemoteIssue reportModel = this.bugTrackersLocalService.createReportIssueTemplate(projectName, exec.getBugTracker(), context);
        this.setDefaultDescriptionIfNeeded(reportModel, context);
        return reportModel;
    }

    private RemoteIssue makeExecutionStepReportIssueModel(ExecutionStep step, String projectName, String squashPublicUrl) {
        RemoteIssueContext context = RemoteIssueContextHelper.getRemoteIssueContext((ExecutionStep)step, (String)squashPublicUrl, (MessageSource)this.messageSource);
        BugTracker bt = step.getExecution().getBugTracker();
        RemoteIssue reportModel = this.bugTrackersLocalService.createReportIssueTemplate(projectName, bt, context);
        this.setDefaultDescriptionIfNeeded(reportModel, context);
        return reportModel;
    }

    private void setDefaultDescriptionIfNeeded(RemoteIssue issue, RemoteIssueContext context) {
        if (issue.getDescription() == null || issue.getDescription().isEmpty()) {
            issue.setDescription(context.getDefaultDescription());
        }
    }

    private IssuesPanelModel makeIssuePanel(String type, Locale locale, Project project) {
        if (project.isBugtrackerConnected()) {
            BugTracker bugtracker = project.findBugTracker();
            AuthenticationStatus status = this.checkStatus(bugtracker, project.getId().longValue());
            BugTrackerInterfaceDescriptor descriptor = this.bugTrackersLocalService.getInterfaceDescriptor(bugtracker);
            descriptor.setLocale(locale);
            String projectNames = JsonHelper.serialize(project.getBugtrackerBinding().getProjectNames().stream().map(HTMLCleanupUtils::cleanAndUnescapeHTML).collect(Collectors.toList()));
            IssuesPanelModel issuesPanelModel = new IssuesPanelModel();
            issuesPanelModel.setProjectId(project.getId());
            issuesPanelModel.setBugTrackerStatus(status);
            issuesPanelModel.setDelete("");
            issuesPanelModel.setEntityType(type);
            issuesPanelModel.setProjectName(projectNames);
            issuesPanelModel.setOslc(this.btFactory.isOslcConnector(bugtracker.getKind()));
            PartyPreference modePreference = this.partyPreferenceService.findPreferenceForCurrentUser(CorePartyPreference.BUGTRACKER_MODE.getPreferenceKey());
            if (modePreference != null) {
                issuesPanelModel.setBugTrackerMode(modePreference.getPreferenceValue());
            }
            return issuesPanelModel;
        }
        return new IssuesPanelModel();
    }

    private AuthenticationStatus checkStatus(BugTracker bugTracker, long projectId) {
        AuthenticationStatus status = this.bugTrackersLocalService.checkBugTrackerStatus(Long.valueOf(projectId));
        if (status == AuthenticationStatus.AUTHENTICATED) {
            try {
                Credentials credentials = this.bugTrackersService.getCredentials(bugTracker);
                this.bugTrackersService.testCredentials(bugTracker, credentials);
            }
            catch (BugTrackerManagerException ex) {
                throw new BugTrackerManagerActionException(ex);
            }
        }
        return status;
    }
}

