/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.model.testautomation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.squashtest.tm.service.internal.display.grid.DataRow;
import org.squashtest.tm.service.internal.display.grid.TreeGridResponse;
import org.squashtest.tm.web.backend.model.testautomation.TATestNode;

public class TATestFlatTree {
    private static String NAME_FIELD = "NAME";
    private static String TYPE_FIELD = "TYPE";

    public TreeGridResponse flatTree(Collection<TATestNode> taTestNodes) {
        ArrayList<DataRow> dataRows = new ArrayList<DataRow>();
        for (TATestNode taTestNode : taTestNodes) {
            DataRow row = new DataRow();
            row.setId(taTestNode.getAttr().getName());
            HashMap<String, String> data = new HashMap<String, String>();
            data.put(NAME_FIELD, taTestNode.getAttr().getName());
            data.put(TYPE_FIELD, taTestNode.getAttr().getRestype());
            row.setData(data);
            if (!taTestNode.getChildren().isEmpty()) {
                row.setState(DataRow.State.closed);
                List childIds = taTestNode.getChildren().stream().map(childNode -> this.generateChildId(childNode, row.getId())).collect(Collectors.toList());
                row.setChildren(childIds);
                this.appendChildren(taTestNode.getChildren(), dataRows, row.getId());
            }
            dataRows.add(row);
        }
        TreeGridResponse treeGridResponse = new TreeGridResponse();
        treeGridResponse.setDataRows(dataRows);
        return treeGridResponse;
    }

    private String generateChildId(TATestNode child, String parentId) {
        return String.valueOf(parentId) + '/' + child.getAttr().getName();
    }

    private void appendChildren(Collection<TATestNode> nodes, List<DataRow> rows, String parentId) {
        for (TATestNode node : nodes) {
            DataRow row = new DataRow();
            row.setId(this.generateChildId(node, parentId));
            HashMap<String, String> data = new HashMap<String, String>();
            data.put(NAME_FIELD, node.getAttr().getName());
            data.put(TYPE_FIELD, node.getAttr().getRestype());
            row.setData(data);
            row.setParentRowId(parentId);
            if (!node.getChildren().isEmpty()) {
                List childIds = node.getChildren().stream().map(childNode -> this.generateChildId(childNode, row.getId())).collect(Collectors.toList());
                row.setChildren(childIds);
                row.setState(DataRow.State.closed);
                this.appendChildren(node.getChildren(), rows, row.getId());
            }
            rows.add(row);
        }
    }
}

