/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.model.builder;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.Workspace;
import org.squashtest.tm.domain.chart.ChartInstance;
import org.squashtest.tm.domain.customreport.CustomReportChartBinding;
import org.squashtest.tm.domain.customreport.CustomReportDashboard;
import org.squashtest.tm.domain.customreport.CustomReportReportBinding;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.report.ReportDefinition;
import org.squashtest.tm.service.chart.ChartModificationService;
import org.squashtest.tm.service.internal.dto.json.JsonChartInstance;
import org.squashtest.tm.service.internal.dto.json.JsonCustomReportChartBinding;
import org.squashtest.tm.service.internal.dto.json.JsonCustomReportDashboard;
import org.squashtest.tm.service.internal.dto.json.JsonCustomReportReportBinding;
import org.squashtest.tm.service.internal.dto.json.JsonReportInstance;
import org.squashtest.tm.service.internal.repository.display.HighLevelRequirementDisplayDao;
import org.squashtest.tm.service.milestone.ActiveMilestoneHolder;
import org.squashtest.tm.web.backend.helper.ReportHelper;
import org.squashtest.tm.web.backend.report.IdentifiedReportDecorator;
import org.squashtest.tm.web.backend.report.ReportsRegistry;
import org.squashtest.tm.web.i18n.InternationalizationHelper;
import org.squashtest.tm.web.i18n.MessageObject;

@Component(value="customReport.dashboardBuilder")
@Scope(value="prototype")
public class JsonCustomReportDashboardBuilder {
    private ChartModificationService chartService;
    private JsonCustomReportDashboard json = new JsonCustomReportDashboard();
    private CustomReportDashboard dashboard;
    private InternationalizationHelper i18nHelper;
    private List<EntityReference> scope;
    private String i18nKeyDateFormat = "squashtm.dateformat";
    private boolean isMilestoneDashboard = false;
    private boolean isExtendedHighLvlReqScope = false;
    private Milestone milestone;
    private Workspace workspace;
    @Inject
    private ReportHelper reportHelper;
    @Inject
    private ReportsRegistry reportsRegistry;
    @Inject
    private HighLevelRequirementDisplayDao highLevelRequirementDisplayDao;
    private static volatile /* synthetic */ int[] $SWITCH_TABLE$org$squashtest$tm$domain$EntityType;

    @Inject
    public JsonCustomReportDashboardBuilder(ChartModificationService chartService, InternationalizationHelper i18nHelper, ActiveMilestoneHolder activeMilestoneHolder) {
        this.chartService = chartService;
        this.i18nHelper = i18nHelper;
        this.milestone = activeMilestoneHolder.getActiveMilestone().orElse(null);
    }

    public JsonCustomReportDashboard build(Long customReportLibraryNodeId, CustomReportDashboard dashboard, Locale locale) {
        return this.getJsonCustomReportDashboard(customReportLibraryNodeId, dashboard, locale);
    }

    public JsonCustomReportDashboard build(Long customReportLibraryNodeId, CustomReportDashboard dashboard, Locale locale, List<EntityReference> scope) {
        this.scope = scope;
        return this.getJsonCustomReportDashboard(customReportLibraryNodeId, dashboard, locale);
    }

    public JsonCustomReportDashboard build(Long customReportLibraryNodeId, CustomReportDashboard dashboard, Locale locale, List<EntityReference> scope, boolean isMilestoneDashboard, Workspace workspace) {
        this.scope = scope;
        this.isMilestoneDashboard = isMilestoneDashboard;
        this.workspace = workspace;
        return this.getJsonCustomReportDashboard(customReportLibraryNodeId, dashboard, locale);
    }

    public JsonCustomReportDashboard build(Long customReportLibraryNodeId, CustomReportDashboard dashboard, Locale locale, List<EntityReference> scope, boolean isMilestoneDashboard, boolean isExtendedHighLvlReqScope, Workspace workspace) {
        this.scope = scope;
        this.isMilestoneDashboard = isMilestoneDashboard;
        this.workspace = workspace;
        this.isExtendedHighLvlReqScope = isExtendedHighLvlReqScope;
        return this.getJsonCustomReportDashboard(customReportLibraryNodeId, dashboard, locale);
    }

    private JsonCustomReportDashboard getJsonCustomReportDashboard(Long customReportLibraryNodeId, CustomReportDashboard dashboard, Locale locale) {
        this.dashboard = dashboard;
        this.json.setCustomReportLibraryNodeId(customReportLibraryNodeId);
        this.doBaseAttributes();
        this.doBindings();
        this.doDateAttributes(locale);
        return this.json;
    }

    private void doBindings() {
        Set bindings = this.dashboard.getChartBindings();
        for (CustomReportChartBinding binding : bindings) {
            JsonCustomReportChartBinding jsonBinding = new JsonCustomReportChartBinding();
            jsonBinding.setId(binding.getId());
            jsonBinding.setDashboardId(this.dashboard.getId());
            jsonBinding.setChartDefinitionId(binding.getChart().getId());
            jsonBinding.setRow(binding.getRow());
            jsonBinding.setCol(binding.getCol());
            jsonBinding.setSizeX(binding.getSizeX());
            jsonBinding.setSizeY(binding.getSizeY());
            if (this.isExtendedHighLvlReqScope) {
                this.scope = this.retrieveExtendedHighLvlReqScope();
            }
            ChartInstance chartInstance = this.isMilestoneDashboard ? this.chartService.generateChartForMilestoneDashboard(binding.getChart(), this.milestone.getId(), this.workspace) : (this.milestone != null ? this.chartService.generateChartInMilestoneMode(binding.getChart(), this.scope, this.workspace) : this.chartService.generateChart(binding.getChart(), this.scope, this.dashboard.getId()));
            jsonBinding.setChartInstance(new JsonChartInstance(chartInstance));
            this.json.getChartBindings().add(jsonBinding);
        }
        Set reportBindings = this.dashboard.getReportBindings();
        for (CustomReportReportBinding reportBinding : reportBindings) {
            ReportDefinition reportDefinition = reportBinding.getReport();
            IdentifiedReportDecorator report = this.reportsRegistry.findReport(reportDefinition.getPluginNamespace());
            JsonCustomReportReportBinding jsonBinding = new JsonCustomReportReportBinding();
            jsonBinding.setId(reportBinding.getId());
            jsonBinding.setDashboardId(this.dashboard.getId());
            jsonBinding.setReportDefinitionId(reportDefinition.getId());
            jsonBinding.setRow(reportBinding.getRow());
            jsonBinding.setCol(reportBinding.getCol());
            jsonBinding.setSizeX(reportBinding.getSizeX());
            jsonBinding.setSizeY(reportBinding.getSizeY());
            JsonReportInstance jsonReportInstance = new JsonReportInstance(reportDefinition);
            if (Objects.nonNull(report)) {
                jsonReportInstance.setLabel(report.getLabel());
                jsonReportInstance.setReportAttributes(this.reportHelper.getAttributesFromReportDefinition(reportDefinition));
                jsonReportInstance.setDocx(Boolean.valueOf(report.isDocxTemplate()));
                jsonReportInstance.setDirectDownloadableReport(Boolean.valueOf(report.isDirectDownloadableReport()));
                if (!report.isDirectDownloadableReport()) {
                    jsonReportInstance.setPdfViews(report.getViews().length);
                }
                jsonBinding.setReportInstance(jsonReportInstance);
            } else {
                jsonReportInstance.setMissingPlugin(true);
                jsonReportInstance.setLabel(reportDefinition.getPluginNamespace());
            }
            this.json.getReportBindings().add(jsonBinding);
        }
    }

    private void doBaseAttributes() {
        this.json.setId(this.dashboard.getId());
        this.json.setProjectId(this.dashboard.getProject().getId());
        this.json.setName(this.dashboard.getName());
        CustomReportDashboard audit = this.dashboard;
        this.json.setCreatedBy(audit.getCreatedBy());
        this.json.setLastModifiedBy(audit.getLastModifiedBy());
    }

    private void doDateAttributes(Locale locale) {
        CustomReportDashboard audit = this.dashboard;
        String dateFormat = this.findI18nDateFormat(locale);
        SimpleDateFormat formater = new SimpleDateFormat(dateFormat);
        this.json.setCreatedOn(formater.format(audit.getCreatedOn()));
        if (audit.getLastModifiedBy() != null) {
            this.json.setLastModifiedOn(formater.format(audit.getLastModifiedOn()));
        } else {
            this.json.setLastModifiedOn("");
        }
    }

    private String findI18nDateFormat(Locale locale) {
        MessageObject message = new MessageObject();
        message.put((Object)this.i18nKeyDateFormat, (Object)this.i18nKeyDateFormat);
        this.i18nHelper.resolve(message, locale);
        return (String)message.get((Object)this.i18nKeyDateFormat);
    }

    private List<EntityReference> retrieveExtendedHighLvlReqScope() {
        ArrayList<EntityReference> references = new ArrayList<EntityReference>();
        ArrayList libIds = new ArrayList();
        ArrayList nodeIds = new ArrayList();
        this.scope.forEach(sc -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.entities.ClassFileField.getField()" because "fieldvar" is null
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewriteEclipse(SwitchEnumRewriter.java:239)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewrite(SwitchEnumRewriter.java:153)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.rewrite(SwitchEnumRewriter.java:86)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:882)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        });
        ArrayList reqIdsWithExtendedHighLvlReqScope = new ArrayList(this.highLevelRequirementDisplayDao.findRequirementIdsByLibraryIds(libIds, true));
        reqIdsWithExtendedHighLvlReqScope.addAll(this.highLevelRequirementDisplayDao.findRequirementIdsByNodeIds(nodeIds, true));
        reqIdsWithExtendedHighLvlReqScope.forEach(reqId -> references.add(new EntityReference(EntityType.REQUIREMENT, reqId)));
        return references;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$org$squashtest$tm$domain$EntityType() {
        if ($SWITCH_TABLE$org$squashtest$tm$domain$EntityType != null) {
            return $SWITCH_TABLE$org$squashtest$tm$domain$EntityType;
        }
        int[] nArray = new int[EntityType.values().length];
        try {
            nArray[EntityType.ACTION_WORD.ordinal()] = 38;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.ACTION_WORD_LIBRARY.ordinal()] = 37;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.ATTACHMENT.ordinal()] = 26;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.ATTACHMENT_LIST.ordinal()] = 27;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.AUTOMATED_EXECUTION_EXTENDER.ordinal()] = 25;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.AUTOMATED_TEST.ordinal()] = 24;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.AUTOMATION_REQUEST.ordinal()] = 28;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.CAMPAIGN.ordinal()] = 13;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.CAMPAIGN_FOLDER.ordinal()] = 12;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.CAMPAIGN_LIBRARY.ordinal()] = 11;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.CHART_DEFINITION.ordinal()] = 34;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.CUSTOM_REPORT_CUSTOM_EXPORT.ordinal()] = 36;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.CUSTOM_REPORT_DASHBOARD.ordinal()] = 33;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.CUSTOM_REPORT_FOLDER.ordinal()] = 32;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.CUSTOM_REPORT_LIBRARY.ordinal()] = 31;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.DATASET.ordinal()] = 29;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.EXECUTION.ordinal()] = 15;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.EXECUTION_STEP.ordinal()] = 17;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.HIGH_LEVEL_REQUIREMENT.ordinal()] = 10;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.INFO_LIST_ITEM.ordinal()] = 21;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.ISSUE.ordinal()] = 19;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.ITEM_TEST_PLAN.ordinal()] = 20;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.ITERATION.ordinal()] = 14;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.MILESTONE.ordinal()] = 23;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.PARAMETER.ordinal()] = 30;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.PROJECT.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.REPORT_DEFINITION.ordinal()] = 35;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.REQUIREMENT.ordinal()] = 8;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.REQUIREMENT_FOLDER.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.REQUIREMENT_LIBRARY.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.REQUIREMENT_VERSION.ordinal()] = 9;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.SCM_REPOSITORY.ordinal()] = 39;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.TEST_CASE.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.TEST_CASE_FOLDER.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.TEST_CASE_LIBRARY.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.TEST_CASE_STEP.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.TEST_STEP.ordinal()] = 18;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.TEST_SUITE.ordinal()] = 16;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.USER.ordinal()] = 22;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$org$squashtest$tm$domain$EntityType = nArray;
        return nArray;
    }
}

