/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.exceptionresolver;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.handler.AbstractHandlerExceptionResolver;
import org.springframework.web.servlet.view.json.MappingJackson2JsonView;
import org.squashtest.tm.core.foundation.exception.ActionException;
import org.squashtest.tm.web.backend.exceptionresolver.model.ActionValidationErrorModel;
import org.squashtest.tm.web.backend.exceptionresolver.model.SquashActionErrorModel;

@Component
public class HandlerActionExceptionResolver
extends AbstractHandlerExceptionResolver {
    protected ModelAndView doResolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        if (this.exceptionIsHandled(ex)) {
            return this.handleException(request, response, ex);
        }
        return null;
    }

    private ModelAndView handleException(HttpServletRequest request, HttpServletResponse response, Exception ex) {
        ActionException actionEx = (ActionException)ex;
        return this.formatJsonResponse(response, actionEx);
    }

    private ModelAndView formatJsonResponse(HttpServletResponse response, ActionException actionEx) {
        response.setStatus(412);
        String exception = actionEx.getClass().getSimpleName();
        ActionValidationErrorModel error = new ActionValidationErrorModel(exception, actionEx.getI18nKey(), actionEx.messageArgs());
        SquashActionErrorModel squashError = new SquashActionErrorModel(error);
        return new ModelAndView((View)new MappingJackson2JsonView(), "squashTMError", (Object)squashError);
    }

    private boolean exceptionIsHandled(Exception ex) {
        return ActionException.class.isAssignableFrom(ex.getClass());
    }
}

