/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.user;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.domain.synchronisation.RemoteSynchronisation;
import org.squashtest.tm.domain.users.UsersGroup;
import org.squashtest.tm.service.display.user.UserDisplayService;
import org.squashtest.tm.service.internal.display.dto.ProjectPermissionDto;
import org.squashtest.tm.service.internal.display.dto.UserAdminViewTeamDto;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.grid.GridResponse;
import org.squashtest.tm.service.project.ProjectsPermissionManagementService;
import org.squashtest.tm.service.user.UserAdministrationService;
import org.squashtest.tm.web.backend.controller.user.UserForm;
import org.squashtest.tm.web.backend.controller.user.UsersAdministrationController;

@Controller
@RequestMapping(value={"/backend/users"})
public class UsersAdministrationController {
    private static final Logger LOGGER = LoggerFactory.getLogger(UsersAdministrationController.class);
    private UserDisplayService userDisplayService;
    private UserAdministrationService adminService;
    private ProjectsPermissionManagementService permissionService;

    @Inject
    public UsersAdministrationController(UserDisplayService userDisplayService, UserAdministrationService adminService, ProjectsPermissionManagementService permissionService) {
        this.userDisplayService = userDisplayService;
        this.adminService = adminService;
        this.permissionService = permissionService;
    }

    @ResponseBody
    @PostMapping
    public GridResponse getAllUsers(@RequestBody GridRequest request) {
        return this.userDisplayService.findAll(request);
    }

    @ResponseBody
    @PostMapping(value={"/new"})
    public Map<String, Long> addUser(@RequestBody @Valid UserForm userForm) {
        if (userForm.getPassword() == null) {
            this.adminService.createUserWithoutCredentials(userForm.getUser(), userForm.getGroupId());
        } else {
            this.adminService.addUser(userForm.getUser(), userForm.getGroupId(), userForm.getPassword());
        }
        return Collections.singletonMap("id", userForm.getUser().getId());
    }

    @ResponseBody
    @GetMapping(value={"/get-users-groups"})
    public Map<String, List<UsersGroup>> getUsersGroups() {
        HashMap<String, List<UsersGroup>> response = new HashMap<String, List<UsersGroup>>();
        response.put("usersGroups", this.adminService.findAllUsersGroupOrderedByQualifiedName());
        return response;
    }

    @RequestMapping(value={"/{userId}/login"}, method={RequestMethod.POST})
    @ResponseBody
    public void modifyLogin(@PathVariable long userId, @RequestBody UserPatch patch) {
        this.adminService.modifyUserLogin(userId, patch.getLogin());
    }

    @RequestMapping(value={"/{userId}/first-name"}, method={RequestMethod.POST})
    @ResponseBody
    public void modifyFirstName(@PathVariable long userId, @RequestBody UserPatch patch) {
        this.adminService.modifyUserFirstName(userId, patch.getFirstName());
    }

    @RequestMapping(value={"/{userId}/last-name"}, method={RequestMethod.POST})
    @ResponseBody
    public void modifyLastName(@PathVariable long userId, @RequestBody UserPatch patch) {
        this.adminService.modifyUserLastName(userId, patch.getLastName());
    }

    @RequestMapping(value={"/{userId}/email"}, method={RequestMethod.POST})
    @ResponseBody
    public void modifyEmail(@PathVariable long userId, @RequestBody UserPatch patch) {
        this.adminService.modifyUserEmail(userId, patch.getEmail());
    }

    @ResponseBody
    @RequestMapping(value={"/{userIds}"}, method={RequestMethod.DELETE})
    public void deleteUsers(@PathVariable(value="userIds") List<Long> userIds) {
        this.adminService.deleteUsers(userIds);
    }

    @GetMapping(value={"/{userId}/synchronisations"})
    @ResponseBody
    public List<RemoteSynchronisation> getSynchronisationsByUser(@PathVariable(value="userId") Long userId) {
        return this.adminService.getSynchronisationsByUser(userId);
    }

    @ResponseBody
    @RequestMapping(value={"/{userIds}/deactivate"}, method={RequestMethod.POST})
    public void deactivateUsers(@PathVariable(value="userIds") List<Long> userIds) {
        this.adminService.deactivateUsers(userIds);
    }

    @ResponseBody
    @RequestMapping(value={"/{userIds}/activate"}, method={RequestMethod.POST})
    public void activateUsers(@PathVariable(value="userIds") List<Long> userIds) {
        this.adminService.activateUsers(userIds);
    }

    @ResponseBody
    @RequestMapping(value={"/{userId}/change-group/{groupId}"}, method={RequestMethod.POST})
    public void changeUserGroup(@PathVariable long userId, @PathVariable long groupId) {
        this.adminService.setUserGroupAuthority(userId, groupId);
    }

    @ResponseBody
    @RequestMapping(value={"/{userId}/reset-password"}, method={RequestMethod.POST})
    public void resetPassword(@PathVariable long userId, @RequestBody UserPatch patch) {
        LOGGER.trace("Reset password for user #" + userId);
        this.adminService.resetUserPassword(userId, patch.getPassword());
    }

    @ResponseBody
    @RequestMapping(value={"/{userId}/permissions/{projectIds}"}, method={RequestMethod.POST})
    public Map<String, List<ProjectPermissionDto>> addNewPermissions(@PathVariable long userId, @PathVariable List<Long> projectIds, @RequestParam String permission) {
        this.permissionService.addNewPermissionToProject(userId, projectIds, permission);
        return Collections.singletonMap("projectPermissions", this.userDisplayService.getProjectPermissions(Long.valueOf(userId)));
    }

    @ResponseBody
    @RequestMapping(value={"/{userId}/permissions/{projectIds}"}, method={RequestMethod.DELETE})
    public void removePermissions(@PathVariable long userId, @PathVariable List<Long> projectIds) {
        this.permissionService.removeProjectPermission(userId, projectIds);
    }

    @ResponseBody
    @RequestMapping(value={"/{userId}/teams/{partyIds}"}, method={RequestMethod.POST})
    public Map<String, List<UserAdminViewTeamDto>> associateTeams(@PathVariable long userId, @PathVariable List<Long> partyIds) {
        this.adminService.associateToTeams(userId, partyIds);
        return Collections.singletonMap("teams", this.userDisplayService.getAssociatedTeams(Long.valueOf(userId)));
    }

    @ResponseBody
    @RequestMapping(value={"/{userId}/teams/{partyIds}"}, method={RequestMethod.DELETE})
    public void disassociateTeams(@PathVariable long userId, @PathVariable List<Long> partyIds) {
        this.adminService.deassociateTeams(userId, partyIds);
    }
}

