/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.test.automation.server;

import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.squashtest.tm.core.foundation.exception.InvalidUrlException;
import org.squashtest.tm.core.foundation.lang.UrlUtils;
import org.squashtest.tm.domain.servers.AuthenticationProtocol;
import org.squashtest.tm.domain.testautomation.TestAutomationServer;
import org.squashtest.tm.exception.WrongUrlException;
import org.squashtest.tm.service.display.test.automation.server.TestAutomationServerDisplayService;
import org.squashtest.tm.service.internal.display.dto.TestAutomationServerDto;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.grid.GridResponse;
import org.squashtest.tm.service.servers.ManageableCredentials;
import org.squashtest.tm.service.servers.ServerAuthConfiguration;
import org.squashtest.tm.service.testautomation.TestAutomationServerManagerService;
import org.squashtest.tm.service.testautomation.environment.AutomatedExecutionEnvironmentService;
import org.squashtest.tm.service.thirdpartyserver.ThirdPartyServerCredentialsService;
import org.squashtest.tm.web.backend.controller.form.model.TestAutomationServerFormModel;
import org.squashtest.tm.web.backend.controller.test.automation.server.TestAutomationServersController;

@Controller
@RequestMapping(value={"/backend/test-automation-servers"})
public class TestAutomationServersController {
    private static final String TEST_AUTOMATION_SERVER_URL = "/{serverIds}";
    private final TestAutomationServerDisplayService testAutomationServerDisplayService;
    private final TestAutomationServerManagerService testAutomationServerManagerService;
    private final ThirdPartyServerCredentialsService credentialsService;
    private final AutomatedExecutionEnvironmentService automatedExecutionEnvironmentService;

    @Inject
    public TestAutomationServersController(TestAutomationServerDisplayService testAutomationServerDisplayService, TestAutomationServerManagerService testAutomationServerManagerService, ThirdPartyServerCredentialsService credentialsService, AutomatedExecutionEnvironmentService automatedExecutionEnvironmentService) {
        this.testAutomationServerDisplayService = testAutomationServerDisplayService;
        this.testAutomationServerManagerService = testAutomationServerManagerService;
        this.credentialsService = credentialsService;
        this.automatedExecutionEnvironmentService = automatedExecutionEnvironmentService;
    }

    @ResponseBody
    @GetMapping
    public Map<String, List<TestAutomationServerDto>> getAll() {
        return Collections.singletonMap("testAutomationServers", this.testAutomationServerDisplayService.findAll());
    }

    @ResponseBody
    @PostMapping
    public GridResponse getAllAutomationServers(@RequestBody GridRequest request) {
        return this.testAutomationServerDisplayService.getTestAutomationServerGrid(request);
    }

    @ResponseBody
    @DeleteMapping(value={"/{serverIds}"})
    public void deleteAutomationServers(@PathVariable(value="serverIds") List<Long> serverIds) {
        this.testAutomationServerManagerService.deleteServer(serverIds);
    }

    @PostMapping(value={"/new"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ResponseBody
    public Map<String, Object> createNewAutomationServer(@RequestBody TestAutomationServerFormModel formModel) {
        this.checkURL(formModel.getBaseUrl());
        TestAutomationServer server = formModel.getTestAutomationServer();
        this.testAutomationServerManagerService.persist(server);
        return Collections.singletonMap("id", server.getId());
    }

    @PostMapping(value={"/{testAutomationServerId}/name"})
    @ResponseBody
    public void changeName(@PathVariable long testAutomationServerId, @RequestBody TestAutomationServerPatch patch) {
        this.testAutomationServerManagerService.changeName(testAutomationServerId, patch.getName());
    }

    @PostMapping(value={"/{testAutomationServerId}/base-url"})
    @ResponseBody
    public void changeURL(@PathVariable long testAutomationServerId, @RequestBody TestAutomationServerPatch patch) {
        URL url = this.checkURL(patch.getBaseUrl());
        this.testAutomationServerManagerService.changeURL(testAutomationServerId, url);
    }

    @PostMapping(value={"/{testAutomationServerId}/description"})
    @ResponseBody
    public void changeDescription(@PathVariable long testAutomationServerId, @RequestBody TestAutomationServerPatch patch) {
        this.testAutomationServerManagerService.changeDescription(testAutomationServerId, patch.getDescription());
    }

    @PostMapping(value={"/{testAutomationServerId}/manual-selection"})
    @ResponseBody
    public void changeManualSelection(@PathVariable long testAutomationServerId, @RequestBody TestAutomationServerPatch patch) {
        this.testAutomationServerManagerService.changeManualSlaveSelection(testAutomationServerId, patch.isManualSlaveSelection());
    }

    @PostMapping(value={"/{testAutomationServerId}/authentication-protocol"})
    @ResponseBody
    public void changeAuthProtocol(@PathVariable long testAutomationServerId, @RequestBody TestAutomationServerPatch patch) {
        AuthenticationProtocol protocol = Enum.valueOf(AuthenticationProtocol.class, patch.getProtocol());
        this.credentialsService.changeAuthenticationProtocol(testAutomationServerId, protocol);
    }

    @PostMapping(value={"/{testAutomationServerId}/authentication-protocol/configuration"})
    @ResponseBody
    public void saveAuthConfiguration(@PathVariable long testAutomationServerId, @Valid @RequestBody ServerAuthConfiguration configuration) {
        this.credentialsService.storeAuthConfiguration(testAutomationServerId, configuration);
    }

    @PostMapping(value={"/{testAutomationServerId}/credentials"})
    @ResponseBody
    public void storeCredentials(@PathVariable long testAutomationServerId, @RequestBody ManageableCredentials credentials) {
        this.credentialsService.storeCredentials(testAutomationServerId, credentials);
        if (this.automatedExecutionEnvironmentService.doesServerSupportAutomatedExecutionEnvironments(testAutomationServerId)) {
            this.testAutomationServerManagerService.clearEnvironmentTags(testAutomationServerId);
        }
    }

    @DeleteMapping(value={"/{testAutomationServerId}/credentials"})
    @ResponseBody
    public void deleteCredentials(@PathVariable long testAutomationServerId) {
        this.credentialsService.deleteCredentials(testAutomationServerId);
    }

    @PostMapping(value={"/{testAutomationServerId}/observer-url"})
    @ResponseBody
    public void changeObserverURL(@PathVariable long testAutomationServerId, @RequestBody TestAutomationServerPatch patch) {
        String observerUrl = patch.getObserverUrl();
        if (StringUtils.isBlank((CharSequence)observerUrl)) {
            this.testAutomationServerManagerService.clearObserverURL(testAutomationServerId);
        } else {
            URL url = this.checkURL(observerUrl);
            this.testAutomationServerManagerService.changeObserverURL(testAutomationServerId, url);
        }
    }

    private URL checkURL(String urlToTest) {
        try {
            return UrlUtils.toUrl((String)urlToTest);
        }
        catch (InvalidUrlException iue) {
            throw new WrongUrlException("baseUrl", (Throwable)iue);
        }
    }
}

