/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.test.automation.server;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.domain.environmenttag.AutomationEnvironmentTag;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.domain.servers.Credentials;
import org.squashtest.tm.domain.servers.TokenAuthCredentials;
import org.squashtest.tm.service.display.test.automation.server.TestAutomationServerDisplayService;
import org.squashtest.tm.service.internal.display.dto.automatedexecutionenvironments.EnvironmentSelectionPanelDto;
import org.squashtest.tm.service.project.CustomProjectModificationService;
import org.squashtest.tm.service.project.GenericProjectFinder;
import org.squashtest.tm.service.servers.StoredCredentialsManager;
import org.squashtest.tm.service.testautomation.TestAutomationServerManagerService;
import org.squashtest.tm.service.testautomation.environment.AutomatedExecutionEnvironmentService;
import org.squashtest.tm.service.testautomation.model.AutomatedExecutionEnvironment;
import org.squashtest.tm.service.testautomation.spi.TestAutomationException;
import org.squashtest.tm.web.backend.controller.form.model.StringList;
import org.squashtest.tm.web.backend.controller.test.automation.server.TestAutomationEnvironmentsController;

@Controller
@RequestMapping(value={"/backend"})
public class TestAutomationEnvironmentsController {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestAutomationEnvironmentsController.class);
    private final AutomatedExecutionEnvironmentService automatedExecutionEnvironmentService;
    private final TestAutomationServerDisplayService testAutomationServerDisplayService;
    private final TestAutomationServerManagerService testAutomationServerManagerService;
    private final CustomProjectModificationService customProjectModificationService;
    private final GenericProjectFinder genericProjectFinder;
    private final StoredCredentialsManager storedCredentialsManager;

    public TestAutomationEnvironmentsController(AutomatedExecutionEnvironmentService automatedExecutionEnvironmentService, TestAutomationServerDisplayService testAutomationServerDisplayService, TestAutomationServerManagerService testAutomationServerManagerService, CustomProjectModificationService customProjectModificationService, GenericProjectFinder genericProjectFinder, StoredCredentialsManager storedCredentialsManager) {
        this.automatedExecutionEnvironmentService = automatedExecutionEnvironmentService;
        this.testAutomationServerDisplayService = testAutomationServerDisplayService;
        this.testAutomationServerManagerService = testAutomationServerManagerService;
        this.customProjectModificationService = customProjectModificationService;
        this.genericProjectFinder = genericProjectFinder;
        this.storedCredentialsManager = storedCredentialsManager;
    }

    @ResponseBody
    @GetMapping(value={"/test-automation-servers/{testAutomationServerId}/automated-execution-environments/all"})
    public EnvironmentSelectionPanelDto getServerEnvironmentsPanel(@PathVariable Long testAutomationServerId) {
        if (this.testAutomationServerDisplayService.hasDefinedCredentials(testAutomationServerId.longValue())) {
            List allAccessibleEnvironments;
            List defaultTags;
            block3: {
                defaultTags = this.testAutomationServerDisplayService.getDefaultEnvironmentTags(testAutomationServerId.longValue());
                allAccessibleEnvironments = null;
                try {
                    allAccessibleEnvironments = this.automatedExecutionEnvironmentService.getAllAccessibleEnvironments(testAutomationServerId);
                }
                catch (TestAutomationException ex) {
                    if (!LOGGER.isTraceEnabled()) break block3;
                    LOGGER.trace(String.format("Could not fetch available automated execution environments for server %d.", testAutomationServerId), (Throwable)ex);
                }
            }
            return EnvironmentSelectionPanelDto.forServer((Long)testAutomationServerId, (List)defaultTags, (List)allAccessibleEnvironments);
        }
        return EnvironmentSelectionPanelDto.forServerWithoutCredentials((Long)testAutomationServerId);
    }

    @ResponseBody
    @GetMapping(value={"/projects/{projectId}/automated-execution-environments/all"})
    public EnvironmentSelectionPanelDto getProjectEnvironmentsPanel(@PathVariable Long projectId) {
        GenericProject project = Objects.requireNonNull(this.genericProjectFinder.findById(projectId.longValue()), String.format("Could not find a project with ID %d.", projectId));
        Objects.requireNonNull(project.getTestAutomationServer(), String.format("Expect project with ID %d to have a test automation server bound.", projectId));
        Long testAutomationServerId = project.getTestAutomationServer().getId();
        boolean hasServerToken = this.testAutomationServerDisplayService.hasDefinedCredentials(testAutomationServerId.longValue());
        Optional optionalProjectToken = this.findProjectToken(testAutomationServerId, projectId);
        boolean hasProjectToken = optionalProjectToken.isPresent();
        if (hasServerToken || hasProjectToken) {
            return this.getProjectEnvironmentPanelResponse(projectId, project, testAutomationServerId, optionalProjectToken, hasServerToken, hasProjectToken);
        }
        return EnvironmentSelectionPanelDto.forProjectWithoutCredentials((Long)testAutomationServerId, (Long)projectId);
    }

    private EnvironmentSelectionPanelDto getProjectEnvironmentPanelResponse(Long projectId, GenericProject project, Long testAutomationServerId, Optional<TokenAuthCredentials> optionalProjectToken, boolean hasServerCredentials, boolean hasProjectToken) {
        List allAccessibleEnvironments;
        boolean areProjectTagsInherited;
        List projectTags;
        List defaultTags;
        block2: {
            defaultTags = this.testAutomationServerDisplayService.getDefaultEnvironmentTags(testAutomationServerId.longValue());
            projectTags = project.getEnvironmentTags().stream().map(AutomationEnvironmentTag::getValue).collect(Collectors.toList());
            areProjectTagsInherited = project.isInheritsEnvironmentTags();
            allAccessibleEnvironments = null;
            try {
                allAccessibleEnvironments = this.getAutomatedExecutionEnvironments(testAutomationServerId, optionalProjectToken);
            }
            catch (TestAutomationException ex) {
                if (!LOGGER.isTraceEnabled()) break block2;
                LOGGER.trace(String.format("Could not fetch available automated execution environments for project %d.", projectId), (Throwable)ex);
            }
        }
        return EnvironmentSelectionPanelDto.forProject((Long)testAutomationServerId, (List)defaultTags, (boolean)hasServerCredentials, (List)allAccessibleEnvironments, (Long)projectId, (boolean)hasProjectToken, projectTags, (boolean)areProjectTagsInherited);
    }

    private List<AutomatedExecutionEnvironment> getAutomatedExecutionEnvironments(Long testAutomationServerId, Optional<TokenAuthCredentials> optionalProjectToken) {
        return optionalProjectToken.isPresent() ? this.automatedExecutionEnvironmentService.getAllAccessibleEnvironments(testAutomationServerId, (Credentials)optionalProjectToken.get()) : this.automatedExecutionEnvironmentService.getAllAccessibleEnvironments(testAutomationServerId);
    }

    private Optional<TokenAuthCredentials> findProjectToken(Long testAutomationServerId, Long projectId) {
        return Optional.ofNullable(this.storedCredentialsManager.findProjectCredentials(testAutomationServerId.longValue(), projectId.longValue())).filter(credentials -> credentials instanceof TokenAuthCredentials).map(credentials -> (TokenAuthCredentials)credentials);
    }

    @ResponseBody
    @GetMapping(value={"/test-automation-servers/{testAutomationServerId}/available-tags"})
    public StringList getAvailableServerEnvironmentTags(@PathVariable Long testAutomationServerId) {
        List environments = this.getAutomatedExecutionEnvironments(testAutomationServerId, Optional.empty());
        return new StringList(this.extractAllTags(environments));
    }

    @ResponseBody
    @GetMapping(value={"/projects/{projectId}/available-tags"})
    public StringList getAvailableProjectEnvironmentTags(@PathVariable Long projectId) {
        GenericProject project = Objects.requireNonNull(this.genericProjectFinder.findById(projectId.longValue()), String.format("Could not find a project with ID %d.", projectId));
        Objects.requireNonNull(project.getTestAutomationServer(), String.format("Expect project with ID %d to have a test automation server bound.", projectId));
        Long testAutomationServerId = project.getTestAutomationServer().getId();
        Optional optionalProjectToken = this.findProjectToken(testAutomationServerId, projectId);
        List environments = this.getAutomatedExecutionEnvironments(testAutomationServerId, optionalProjectToken);
        return new StringList(this.extractAllTags(environments));
    }

    private List<String> extractAllTags(List<AutomatedExecutionEnvironment> environments) {
        return environments.stream().map(AutomatedExecutionEnvironment::getTags).flatMap(Collection::stream).distinct().sorted().collect(Collectors.toList());
    }

    @ResponseBody
    @PostMapping(value={"/test-automation-servers/{testAutomationServerId}/environment-tags"})
    public void updateServerEnvironmentTags(@PathVariable Long testAutomationServerId, @RequestBody StringList tagList) {
        this.testAutomationServerManagerService.updateEnvironmentTags(testAutomationServerId.longValue(), tagList.getList());
    }

    @ResponseBody
    @PostMapping(value={"/projects/{projectId}/environment-tags"})
    public void updateProjectEnvironmentTags(@PathVariable Long projectId, @RequestBody StringList tagList) {
        this.customProjectModificationService.overrideEnvironmentTags(projectId.longValue(), tagList.getList());
    }

    @ResponseBody
    @DeleteMapping(value={"/projects/{projectId}/environment-tags"})
    public void clearProjectTagOverrides(@PathVariable Long projectId) {
        this.customProjectModificationService.clearEnvironmentTagOverrides(projectId.longValue());
    }

    @ResponseBody
    @PostMapping(value={"/projects/{projectId}/automated-execution-environments/tokens/{serverId}"})
    public void changeTAServerTokenOverride(@PathVariable Long projectId, @PathVariable Long serverId, @RequestBody TokenOverrideRequestBody body) {
        this.customProjectModificationService.setTestAutomationServerTokenOverride(projectId.longValue(), serverId.longValue(), body.token);
    }

    @ResponseBody
    @DeleteMapping(value={"/projects/{projectId}/automated-execution-environments/tokens/{serverId}"})
    public void clearTAServerTokenOverride(@PathVariable Long projectId, @PathVariable Long serverId) {
        this.customProjectModificationService.clearTestAutomationServerTokenOverride(projectId.longValue(), serverId.longValue());
    }
}

