/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.requirement;

import java.util.Collection;
import java.util.Set;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.domain.NodeReferences;
import org.squashtest.tm.service.requirement.RequirementLibraryNavigationService;
import org.squashtest.tm.service.statistics.requirement.RequirementStatisticsBundle;
import org.squashtest.tm.web.backend.controller.requirement.RequirementStatisticsController;

@RestController
@RequestMapping(value={"/backend/requirement/statistics"})
public class RequirementStatisticsController {
    private final RequirementLibraryNavigationService requirementLibraryNavigationService;

    public RequirementStatisticsController(RequirementLibraryNavigationService requirementLibraryNavigationService) {
        this.requirementLibraryNavigationService = requirementLibraryNavigationService;
    }

    @ResponseBody
    @PostMapping
    public RequirementStatisticsBundle getStatistics(@RequestBody RequirementNodeList nodeList) {
        NodeReferences nodeReferences = nodeList.asNodeReferences();
        Set libraryIds = nodeReferences.extractLibraryIds();
        Set nodeIds = nodeReferences.extractNonLibraryIds();
        return this.requirementLibraryNavigationService.getStatisticsForSelection((Collection)libraryIds, (Collection)nodeIds, nodeList.isExtendedHighLvlReqScope());
    }
}

