/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.report;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.squashtest.tm.api.report.StandardReportCategory;
import org.squashtest.tm.api.report.jasperreports.JasperReportsView;
import org.squashtest.tm.web.backend.controller.report.BasicInputJson;
import org.squashtest.tm.web.backend.controller.report.InputJson;
import org.squashtest.tm.web.backend.controller.report.ReportViewJson;
import org.squashtest.tm.web.backend.report.IdentifiedReportDecorator;

class ReportData {
    public final String label;
    public final String id;
    public final String description;
    public final StandardReportCategory category;
    public final List<InputJson> inputs;
    public final Boolean isDocxTemplate;
    public final Boolean isDirectDownloadableReport;
    public final List<ReportViewJson> views;

    public ReportData(IdentifiedReportDecorator report) {
        this.label = report.getLabel();
        this.id = report.getIdentifier().getNamespace();
        this.category = report.getCategory();
        this.description = report.getDescription();
        this.isDocxTemplate = report.isDocxTemplate();
        this.isDirectDownloadableReport = report.isDirectDownloadableReport();
        this.inputs = Arrays.stream(report.getForm()).map(BasicInputJson::fromInput).collect(Collectors.toList());
        this.views = report.isDocxTemplate() || report.isDirectDownloadableReport() ? Collections.emptyList() : Arrays.stream(report.getViews()).map(reportView -> (JasperReportsView)reportView).map(ReportViewJson::new).collect(Collectors.toList());
    }
}

