/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.export;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.export.JRCsvExporterParameter;
import net.sf.jasperreports.engine.export.JRXlsAbstractExporterParameter;
import org.springframework.context.MessageSource;
import org.springframework.context.support.MessageSourceResourceBundle;
import org.squashtest.tm.domain.library.ExportData;
import org.squashtest.tm.service.internal.utils.HTMLCleanupUtils;
import org.squashtest.tm.web.backend.report.service.JasperReportsService;

/*
 * Exception performing whole class analysis ignored.
 */
public final class ExportUtil {
    private static final int EOF = -1;

    public static void printExport(List<? extends ExportData> dataSource, String filename, String jasperFile, HttpServletResponse response, Locale locale, String format, boolean keepRteFormat, Map<String, Object> reportParameters, MessageSource messageSource, JasperReportsService jrServices) {
        try {
            if (!keepRteFormat) {
                ExportUtil.removeRteFormat(dataSource);
            }
            reportParameters.put("REPORT_LOCALE", locale);
            reportParameters.put("REPORT_RESOURCE_BUNDLE", new MessageSourceResourceBundle(messageSource, locale));
            HashMap<Object, Object> exportParameter = new HashMap<Object, Object>();
            exportParameter.put(JRCsvExporterParameter.FIELD_DELIMITER, ";");
            exportParameter.put(JRExporterParameter.CHARACTER_ENCODING, "ISO-8859-1");
            exportParameter.put(JRXlsAbstractExporterParameter.IS_WHITE_PAGE_BACKGROUND, Boolean.FALSE);
            InputStream jsStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(jasperFile);
            InputStream reportStream = jrServices.getReportAsStream(jsStream, format, dataSource, reportParameters, exportParameter);
            ServletOutputStream servletStream = response.getOutputStream();
            response.setContentType("application/octet-stream");
            response.setHeader("Content-Disposition", "attachment; filename=" + filename + "." + format);
            ExportUtil.flushStreams((InputStream)reportStream, (ServletOutputStream)servletStream);
            reportStream.close();
            servletStream.close();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private static void flushStreams(InputStream inStream, ServletOutputStream outStream) throws IOException {
        int readByte;
        do {
            if ((readByte = inStream.read()) == -1) continue;
            outStream.write(readByte);
        } while (readByte != -1);
    }

    private static void removeRteFormat(List<? extends ExportData> dataSource) {
        for (ExportData exportData : dataSource) {
            String htmlDescription = exportData.getDescription();
            String description = HTMLCleanupUtils.htmlToTrimmedText((String)htmlDescription);
            exportData.setDescription(description);
        }
    }
}

