/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller;

import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import org.squashtest.tm.service.user.UserAdministrationService;

/*
 * Exception performing whole class analysis ignored.
 */
@Controller
public class RootController {
    public static final String REDIRECT_AFTER_AUTH = "redirect-after-auth";
    public static final String INTERNAL_LOGIN_URL = "/login";
    public static final String AUTOMATION_WORKSPACE_URL = "/automation-workspace";
    public static final String HOME_WORKSPACE_URL = "/home-workspace";
    private static final Logger LOGGER = LoggerFactory.getLogger(RootController.class);
    private final UserAdministrationService userAdministrationService;
    @Value(value="${squash.security.preferred-auth-url:/login}")
    private String preferredAuthUrl = "/login";

    public RootController(UserAdministrationService userAdministrationService) {
        this.userAdministrationService = userAdministrationService;
    }

    @GetMapping(value={"/"})
    public String mainEntryPoint(HttpServletRequest request, RedirectAttributes redirectAttributes, HttpSession httpSession) {
        boolean authenticated = RootController.isAuthenticated();
        if (authenticated) {
            String redirectUrl = this.restoreRedirectionUrl(request, httpSession);
            if (!this.userAdministrationService.findPostLoginInformation().isEmpty()) {
                redirectUrl = String.format("/information?%s=%s", "redirect-after-auth", redirectUrl);
            }
            LOGGER.info("Received GET request on \"/\". User is authenticated, redirecting to " + redirectUrl);
            return "redirect:" + redirectUrl;
        }
        redirectAttributes.addAllAttributes(request.getParameterMap());
        httpSession.setAttribute("redirect-after-auth", request.getParameterMap().get("redirect-after-auth"));
        LOGGER.info("Received GET request on \"/\". User is not authenticated, redirecting to " + this.preferredAuthUrl);
        return "redirect:" + this.preferredAuthUrl;
    }

    private String restoreRedirectionUrl(HttpServletRequest request, HttpSession httpSession) {
        Object redirectInSession;
        String redirectUrl = RootController.getDefaultAuthenticatedRedirectUrlForUserAuthority();
        String[] redirectInQueryParams = (String[])request.getParameterMap().get("redirect-after-auth");
        if ((redirectInQueryParams == null || redirectInQueryParams.length == 0) && (redirectInSession = httpSession.getAttribute("redirect-after-auth")) instanceof String[] && ((String[])redirectInSession).length > 0) {
            httpSession.removeAttribute("redirect-after-auth");
            redirectUrl = ((String[])redirectInSession)[0];
            LOGGER.info("Found a redirect-after-auth attribute is session. Redirect url is now set to " + redirectUrl);
        }
        return redirectUrl;
    }

    private static boolean isAuthenticated() {
        SecurityContext securityContext = SecurityContextHolder.getContext();
        Authentication authentication = securityContext.getAuthentication();
        boolean isAnonymous = authentication instanceof AnonymousAuthenticationToken;
        return authentication != null && authentication.isAuthenticated() && !isAnonymous;
    }

    public static String getDefaultAuthenticatedRedirectUrlForUserAuthority() {
        SecurityContext securityContext = SecurityContextHolder.getContext();
        Authentication authentication = securityContext.getAuthentication();
        Collection authorities = authentication.getAuthorities();
        if (RootController.isUserProgrammerButNotTester((Collection)authorities)) {
            return "/automation-workspace";
        }
        return "/home-workspace";
    }

    public static boolean isUserProgrammerButNotTester(Collection<? extends GrantedAuthority> authorities) {
        return authorities.stream().anyMatch(auth -> "ROLE_TF_AUTOMATION_PROGRAMMER".equals(auth.getAuthority())) && authorities.stream().noneMatch(auth -> "ROLE_TF_FUNCTIONAL_TESTER".equals(auth.getAuthority()));
    }
}

