/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.config;

import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.web.servlet.resource.PathResourceResolver;

public class SquashResourceResolver
extends PathResourceResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(SquashResourceResolver.class);
    private String baseApiPath = "backend";

    protected Resource getResource(String resourcePath, Resource location) throws IOException {
        LOGGER.debug("Try to resolve resource for resource : {} ", (Object)resourcePath);
        if (resourcePath.startsWith(this.baseApiPath) || resourcePath.startsWith("/error") || resourcePath.startsWith("error") || resourcePath.startsWith(this.baseApiPath.substring(1))) {
            LOGGER.debug("{} seems to be a call to data controllers, returning null.", (Object)resourcePath);
            return null;
        }
        if (resourcePath.startsWith("/plugin/") || resourcePath.startsWith("plugin/")) {
            LOGGER.debug("{} seems to be a call to plugin. Try to resolve plugin app.", (Object)resourcePath);
            String[] parts = resourcePath.split("/");
            ClassPathResource pluginRootPage = null;
            if (parts.length > 1) {
                LOGGER.debug("Requested plugin root page is {}", (Object)parts[1]);
                pluginRootPage = new ClassPathResource("/META-INF/resources/" + parts[1] + "/index.html");
                LOGGER.debug("Resolved plugin, root page : {}. class path resource is : {}.", (Object)parts[1], (Object)pluginRootPage);
            }
            return pluginRootPage != null && pluginRootPage.exists() && pluginRootPage.isReadable() ? pluginRootPage : null;
        }
        return location.exists() && location.isReadable() ? location : null;
    }
}

