/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.model.builder;

import java.util.Objects;
import javax.inject.Inject;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.customreport.CustomReportReportBinding;
import org.squashtest.tm.domain.report.ReportDefinition;
import org.squashtest.tm.service.internal.dto.json.JsonCustomReportReportBinding;
import org.squashtest.tm.service.internal.dto.json.JsonReportInstance;
import org.squashtest.tm.service.report.ReportModificationService;
import org.squashtest.tm.web.backend.helper.ReportHelper;
import org.squashtest.tm.web.backend.report.IdentifiedReportDecorator;
import org.squashtest.tm.web.backend.report.ReportsRegistry;

@Component(value="customReport.reportBindingBuilder")
@Scope(value="prototype")
public class JsonCustomReportReportBindingBuilder {
    private ReportModificationService reportService;
    @Inject
    private ReportHelper reportHelper;
    @Inject
    private ReportsRegistry reportsRegistry;
    private JsonCustomReportReportBinding json = new JsonCustomReportReportBinding();

    @Inject
    public JsonCustomReportReportBindingBuilder(ReportModificationService reportService) {
        this.reportService = reportService;
    }

    public JsonCustomReportReportBinding build(CustomReportReportBinding binding) {
        ReportDefinition reportDefinition = binding.getReport();
        IdentifiedReportDecorator report = this.reportsRegistry.findReport(reportDefinition.getPluginNamespace());
        this.json.setId(binding.getId());
        this.json.setReportDefinitionId(reportDefinition.getId());
        this.json.setDashboardId(binding.getDashboard().getId());
        this.json.setCol(binding.getCol());
        this.json.setRow(binding.getRow());
        this.json.setSizeX(binding.getSizeX());
        this.json.setSizeY(binding.getSizeY());
        JsonReportInstance jsonReportInstance = new JsonReportInstance(reportDefinition);
        if (Objects.nonNull(report)) {
            jsonReportInstance.setLabel(report.getLabel());
            jsonReportInstance.setReportAttributes(this.reportHelper.getAttributesFromReportDefinition(reportDefinition));
            jsonReportInstance.setDocx(Boolean.valueOf(report.isDocxTemplate()));
            jsonReportInstance.setPdfViews(report.getViews().length);
        } else {
            jsonReportInstance.setMissingPlugin(true);
            jsonReportInstance.setLabel(reportDefinition.getPluginNamespace());
        }
        this.json.setReportInstance(jsonReportInstance);
        return this.json;
    }
}

