/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.thirdpartyserver;

import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.domain.servers.AuthenticationStatus;
import org.squashtest.tm.service.bugtracker.BugTrackersLocalService;
import org.squashtest.tm.service.configuration.ConfigurationService;
import org.squashtest.tm.service.servers.ManageableCredentials;
import org.squashtest.tm.service.servers.OAuth1aConsumerService;
import org.squashtest.tm.service.servers.OAuth1aTemporaryTokens;
import org.squashtest.tm.service.user.UserAccountService;
import org.squashtest.tm.web.backend.controller.thirdpartyserver.UriUtils;

@Controller
@RequestMapping(value={"backend/servers"})
public class ThirdPartyServersAuthenticationController {
    private static final String SQUASH_TM_CALLBACK_URL_KEY = "squashtest.tm.callbackurl";
    private static final Logger LOGGER = LoggerFactory.getLogger(ThirdPartyServersAuthenticationController.class);
    public static final String OAUTH_1_A_TEMP_TOKENS = "squashtest.servers.OAUTH_1_A_TEMP_TOKENS";
    @Value(value="${tm.test.automation.server.callbackurl}")
    private String baseCallbackUrl;
    @Inject
    private ConfigurationService configService;
    @Inject
    private BugTrackersLocalService btService;
    @Inject
    private OAuth1aConsumerService oauth1aService;
    @Inject
    private UserAccountService userService;

    @RequestMapping(value={"/{serverId}/authentication"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public AuthenticationStatus getAuthenticationStatus(@PathVariable(value="serverId") Long serverId) {
        return this.btService.checkAuthenticationStatus(serverId);
    }

    @ResponseBody
    @PostMapping(value={"/{serverId}/authentication"})
    public void authenticate(@RequestBody ManageableCredentials credentials, @PathVariable(value="serverId") long serverId) {
        this.btService.validateManageableCredentials(serverId, credentials, false);
        this.userService.saveCurrentUserCredentials(serverId, credentials);
    }

    @RequestMapping(value={"/{serverId}/authentication/oauth1a"}, method={RequestMethod.GET})
    public String authenticateOauth1(HttpServletRequest request, HttpSession session, @PathVariable(value="serverId") long serverId) {
        try {
            String callbackUrl = this.createCallbackUrl(request, serverId);
            OAuth1aTemporaryTokens tokens = this.oauth1aService.requestTemporaryToken(serverId, callbackUrl);
            session.setAttribute(OAUTH_1_A_TEMP_TOKENS, (Object)tokens);
            return "redirect:" + tokens.getRedirectUrl();
        }
        catch (Exception ex) {
            LOGGER.error("Exception encountered while fetching temporary credentials : ", (Throwable)ex);
            return "redirect:" + this.createFailureUrl(request);
        }
    }

    @RequestMapping(value={"/{serverId}/authentication/oauth1a/callback"}, method={RequestMethod.GET})
    public String callbackOAuth1(HttpSession session, HttpServletRequest request, @PathVariable(value="serverId") long serverId, @RequestParam(value="oauth_token") String oauthToken, @RequestParam(value="oauth_verifier") String oauthVerifier) {
        String redirection = this.createSuccessUrl(request);
        try {
            OAuth1aTemporaryTokens tempTokens = (OAuth1aTemporaryTokens)session.getAttribute(OAUTH_1_A_TEMP_TOKENS);
            if (tempTokens == null) {
                String user = this.findUsernameOrUndefined();
                LOGGER.error("oauth callback (user '{}', server '{}') : unexpected call to the oauth1 consumer callback, no temporary tokens found user session !", (Object)user, (Object)serverId);
                redirection = this.createFailureUrl(request);
            } else if (!oauthToken.equals(tempTokens.getTempToken())) {
                String user = this.findUsernameOrUndefined();
                LOGGER.error("oauth callback (user '{}', server '{}') : received token '{}' but expected '{}'", new Object[]{user, serverId, oauthToken, tempTokens.getTempToken()});
                redirection = this.createFailureUrl(request);
            } else {
                tempTokens.setVerifier(oauthVerifier);
                this.oauth1aService.authorize(serverId, tempTokens);
                session.removeAttribute(OAUTH_1_A_TEMP_TOKENS);
            }
        }
        catch (ClassCastException ex) {
            String user = this.findUsernameOrUndefined();
            LOGGER.error("oauth callback (user '{}', server '{}') : programmatic error, exception is ", new Object[]{user, serverId, ex});
            redirection = this.createFailureUrl(request);
        }
        catch (Exception exception) {
            String user = this.findUsernameOrUndefined();
            LOGGER.error("oauth callback (user '{}', server '{}') : unhandled error, exception is ", new Object[]{user, serverId, exception});
            redirection = this.createFailureUrl(request);
        }
        return "redirect:" + redirection;
    }

    private String findUsernameOrUndefined() {
        try {
            SecurityContext sec = SecurityContextHolder.getContext();
            String username = sec.getAuthentication().getName();
            return username != null ? username : "(unknown)";
        }
        catch (Exception ex) {
            LOGGER.debug("attempted to retrieve the current username for debugging purposes but failed to retrieve one. Probable cause is that no user context is set. It is also likely that the error reported below was caused for that same reason.", (Throwable)ex);
            return "(unknown)";
        }
    }

    private String createCallbackUrl(HttpServletRequest request, long serverId) {
        return String.valueOf(this.getBaseUrl(request)) + "/backend/servers/" + serverId + "/authentication/oauth1a/callback";
    }

    private String createSuccessUrl(HttpServletRequest request) {
        return String.valueOf(this.getBaseUrl(request)) + "/oauth/success";
    }

    private String createFailureUrl(HttpServletRequest request) {
        return String.valueOf(this.getBaseUrl(request)) + "/oauth/failure";
    }

    private String getBaseUrl(HttpServletRequest request) {
        if (this.isCallbackUrlSetInDatabase()) {
            return this.configService.findConfiguration(SQUASH_TM_CALLBACK_URL_KEY);
        }
        if (this.isCallbackUrlSetInProperties()) {
            return this.baseCallbackUrl;
        }
        return UriUtils.extractBaseUrl((HttpServletRequest)request);
    }

    private boolean isCallbackUrlSetInProperties() {
        return !StringUtils.isBlank((CharSequence)this.baseCallbackUrl) && !this.baseCallbackUrl.contains("localhost");
    }

    private boolean isCallbackUrlSetInDatabase() {
        String callbackUrl = this.configService.findConfiguration(SQUASH_TM_CALLBACK_URL_KEY);
        return callbackUrl != null;
    }
}

