/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.tf;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.core.foundation.exception.InvalidUrlException;
import org.squashtest.tm.core.foundation.lang.UrlUtils;
import org.squashtest.tm.domain.tf.automationrequest.AutomationRequestStatus;
import org.squashtest.tm.exception.WrongUrlException;
import org.squashtest.tm.exception.tf.WrongPriorityFormatException;
import org.squashtest.tm.service.display.testcase.TestCaseDisplayService;
import org.squashtest.tm.service.internal.display.dto.testcase.TestCaseDto;
import org.squashtest.tm.service.testcase.TestCaseModificationService;
import org.squashtest.tm.service.tf.AutomationRequestModificationService;
import org.squashtest.tm.web.backend.controller.tf.AutomationModificationViewController;
import org.squashtest.tm.web.backend.model.testautomation.TATestNode;
import org.squashtest.tm.web.backend.model.testautomation.TATestNodeListBuilder;

@Controller
@RequestMapping(value={"/backend/automation-requests"})
public class AutomationModificationViewController {
    public static final Logger LOGGER = LoggerFactory.getLogger(AutomationModificationViewController.class);
    private static final String TEST_CASE_ID = "testCaseId";
    private static final String PATH = "path";
    private static final String TEST_SPACE_CASE = "test case ";
    private TestCaseModificationService testCaseModificationService;
    private TestCaseDisplayService testCaseDisplayService;
    private AutomationRequestModificationService automationRequestModificationService;

    public AutomationModificationViewController(TestCaseModificationService testCaseModificationService, TestCaseDisplayService testCaseDisplayService, AutomationRequestModificationService automationRequestModificationService) {
        this.testCaseModificationService = testCaseModificationService;
        this.testCaseDisplayService = testCaseDisplayService;
        this.automationRequestModificationService = automationRequestModificationService;
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.POST}, value={"/{tcIds}/status"})
    public List<TestCaseDto> changeStatus(@PathVariable List<Long> tcIds, @RequestBody String status) {
        this.automationRequestModificationService.changeStatus(tcIds, AutomationRequestStatus.valueOf((String)status));
        return tcIds.stream().map(id -> this.testCaseDisplayService.getTestCaseView(id.longValue())).collect(Collectors.toList());
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.POST}, value={"/{tcIds}/request-status"})
    public Map<Long, String> changeAutomationRequestStatus(@PathVariable List<Long> tcIds, @RequestBody TestCaseAutomationPatch patch) {
        return this.automationRequestModificationService.changeStatus(tcIds, AutomationRequestStatus.valueOf((String)patch.getRequestStatus()));
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.POST}, value={"/{tcIds}/unassign"})
    public void unassignedUser(@PathVariable(value="tcIds") List<Long> tcIds) {
        this.automationRequestModificationService.unassignRequests(tcIds);
    }

    @RequestMapping(value={"{testCaseId}/tests"}, method={RequestMethod.POST}, params={"path"})
    @ResponseBody
    public String bindAutomatedTest(@PathVariable(value="testCaseId") long testCaseId, @RequestParam(value="path") String testPath) {
        this.testCaseModificationService.bindAutomatedTestByAutomationProgrammer(Long.valueOf(testCaseId), testPath);
        return testPath;
    }

    @RequestMapping(value={"{testCaseId}/tests"}, method={RequestMethod.GET})
    @ResponseBody
    public Collection<TATestNode> findAssignableAutomatedTests(@PathVariable(value="testCaseId") Long testCaseId) {
        Collection projectContents = this.testCaseModificationService.findAssignableAutomationTestsToAutomationProgramer(testCaseId.longValue());
        return new TATestNodeListBuilder().build(projectContents);
    }

    @RequestMapping(method={RequestMethod.POST}, value={"{testCaseId}/automatedTestTechnology"})
    @ResponseBody
    public void changeAutomatedTestTechnology(@RequestBody TestCaseAutomationPatch patch, @PathVariable long testCaseId) {
        if (patch.getAutomatedTestTechnology() != null) {
            this.testCaseModificationService.changeAutomatedTestTechnology(testCaseId, patch.getAutomatedTestTechnology().longValue());
        } else {
            this.testCaseModificationService.unbindAutomatedTestTechnology(testCaseId);
        }
    }

    @RequestMapping(method={RequestMethod.POST}, value={"{testCaseId}/automatedTestReference"})
    @ResponseBody
    public void changeAutomatedTestReference(@RequestBody TestCaseAutomationPatch patch, @PathVariable long testCaseId) {
        this.testCaseModificationService.changeAutomatedTestReference(testCaseId, patch.getAutomatedTestReference());
    }

    @RequestMapping(method={RequestMethod.POST}, value={"{testCaseId}/automationPriority"})
    @ResponseBody
    public void changeAutomationPriority(@RequestBody TestCaseAutomationPatch patch, @PathVariable long testCaseId) {
        try {
            Integer newPriority = patch.automationPriority.isEmpty() ? null : Integer.valueOf(Integer.parseInt(patch.automationPriority));
            this.testCaseModificationService.changeAutomationPriority(testCaseId, newPriority);
        }
        catch (NumberFormatException nfe) {
            throw new WrongPriorityFormatException((Exception)nfe);
        }
    }

    @RequestMapping(value={"/{tcIds}/assign"}, method={RequestMethod.POST})
    @ResponseBody
    public void assigneeToAutomationReq(@PathVariable(value="tcIds") List<Long> tcIds) {
        this.automationRequestModificationService.assignedToRequest(tcIds);
    }

    @RequestMapping(value={"/{tcIds}/associate-TA-script"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<Long, String> resolveTAScriptAssociation(@PathVariable(value="tcIds") List<Long> tcIds) {
        return this.automationRequestModificationService.updateTAScript(tcIds);
    }

    @ResponseBody
    @RequestMapping(value={"/associate-TA-script"}, method={RequestMethod.POST}, params={"iterationId"})
    public Map<Long, String> resolveTAScriptAssociationForIteration(@RequestParam(value="iterationId") long iterationId) {
        return this.automationRequestModificationService.updateTAScriptForIteration(Long.valueOf(iterationId));
    }

    @ResponseBody
    @RequestMapping(value={"/associate-TA-script"}, method={RequestMethod.POST}, params={"testSuiteId"})
    public Map<Long, String> resolveTAScriptAssociationForTestSuite(@RequestParam(value="testSuiteId") long testSuiteId) {
        return this.automationRequestModificationService.updateTAScriptForTestSuite(Long.valueOf(testSuiteId));
    }

    @ResponseBody
    @RequestMapping(value={"/associate-TA-script"}, method={RequestMethod.POST}, params={"testPlanItemsIds[]"})
    public Map<Long, String> resolveTAScriptAssociationForIterationItems(@RequestParam(value="testPlanItemsIds[]") List<Long> testPlanIds) {
        return this.automationRequestModificationService.updateTAScriptForItems(testPlanIds);
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/{tcId}/source-code-repository-url"})
    @ResponseBody
    public void changeSourceCodeRepositoryUrl(@PathVariable Long tcId, @RequestBody TestCaseAutomationPatch patch) throws WrongUrlException {
        String testCaseSourceCodeRepositoryUrl = patch.getTestCaseSourceRepositoryUrl();
        if (!(testCaseSourceCodeRepositoryUrl = testCaseSourceCodeRepositoryUrl.substring(0, Math.min(testCaseSourceCodeRepositoryUrl.length(), 255))).isEmpty()) {
            try {
                UrlUtils.toUrl((String)testCaseSourceCodeRepositoryUrl);
            }
            catch (InvalidUrlException iue) {
                throw new WrongUrlException("url", (Throwable)iue);
            }
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(TEST_SPACE_CASE + tcId + ": updated git repository url to " + testCaseSourceCodeRepositoryUrl);
        }
    }
}

